/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.MathElement;
import jigcell.sbml2.Model;
import jigcell.sbml2.Parameter;
import jigcell.sbml2.SBase;
import jigcell.sbml2.SBaseId;
import jigcell.sbml2.UnitDefinition;
import jigcell.sbml2.XMLPrinter;
import org.xml.sax.Attributes;

public final class KineticLaw
extends SBase
implements MathElement {
    private final List parameter;
    private final SBase parameterElement;
    private String math;
    private String substanceUnits;
    private String timeUnits;
    static final /* synthetic */ boolean $assertionsDisabled;

    public KineticLaw() {
        this((String)null);
    }

    public KineticLaw(KineticLaw law) {
        this(law.getMath());
        this.setSubstanceUnits(law.getSubstanceUnits());
        this.setTimeUnits(law.getTimeUnits());
        Iterator iterator = law.getParameter().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter == null) continue;
            this.addParameter(new Parameter(parameter));
        }
    }

    public KineticLaw(String math) {
        this.setMath(math);
        this.parameterElement = new SBase();
        this.parameter = new ArrayList();
    }

    public void addParameter(Parameter element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        this.parameter.add(element);
    }

    public Parameter findParameterWithId(String id) {
        return (Parameter)KineticLaw.searchListForId(this.parameter, id);
    }

    public String getMath() {
        return this.math;
    }

    public List getParameter() {
        return this.parameter;
    }

    public SBase getParameterElement() {
        return this.parameterElement;
    }

    public String getSubstanceUnits() {
        return this.substanceUnits == null ? "substance" : this.substanceUnits;
    }

    public UnitDefinition getSubstanceUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getSubstanceUnits(), 64);
    }

    public String getTimeUnits() {
        return this.timeUnits == null ? "time" : this.timeUnits;
    }

    public UnitDefinition getTimeUnits(Model model) {
        return (UnitDefinition)model.findElementWithId(this.getTimeUnits(), 64);
    }

    public boolean isValid(Model model) {
        return super.isValid(model) && UnitDefinition.isValidTimeUnit(this.getTimeUnits(model)) && UnitDefinition.isValidSubstanceUnit(this.getSubstanceUnits(model));
    }

    public void setMath(String math) {
        if (!$assertionsDisabled && math != null && !math.startsWith("<math:math>")) {
            throw new AssertionError();
        }
        this.math = math;
    }

    public void setSubstanceUnits(String substanceUnits) {
        if (substanceUnits != null && !SBaseId.isValidId(substanceUnits)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.substanceUnits = substanceUnits;
    }

    public void setSubstanceUnits(UnitDefinition units) {
        this.setSubstanceUnits(units == null ? null : units.getId());
    }

    public void setTimeUnits(String timeUnits) {
        if (timeUnits != null && !SBaseId.isValidId(timeUnits)) {
            throw new IllegalArgumentException("Invalid SBML identifier.");
        }
        this.timeUnits = timeUnits;
    }

    public void setTimeUnits(UnitDefinition units) {
        this.setTimeUnits(units == null ? null : units.getId());
    }

    protected void parse(Attributes attributes) {
        super.parse(attributes);
        this.setSubstanceUnits(attributes.getValue("substanceUnits"));
        this.setTimeUnits(attributes.getValue("timeUnits"));
    }

    protected XMLPrinter print(XMLPrinter parent) {
        return this.print(parent, "kineticLaw");
    }

    protected XMLPrinter print(XMLPrinter parent, String name) {
        XMLPrinter printer = super.print(parent, name);
        if (!this.getTimeUnits().equals("time")) {
            printer.addAttribute("timeUnits", this.getTimeUnits());
        }
        if (!this.getSubstanceUnits().equals("substance")) {
            printer.addAttribute("substanceUnits", this.getSubstanceUnits());
        }
        printer.addText(this.getMath());
        printer.addElementList(this.getParameterElement(), "listOfParameters", this.getParameter());
        return printer;
    }

    static {
        $assertionsDisabled = !KineticLaw.class.desiredAssertionStatus();
    }
}

