/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.math;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import jigcell.sbml2.math.MathMLExpression;
import jigcell.sbml2.math.Node;
import jigcell.sbml2.math.SymbolTable;

public class InfixExpression {
    private boolean lookupSymbols = true;
    private ArrayList expression;
    private SymbolTable symbolTable;
    private SymbolTable localSymbols;
    private static Hashtable map = null;
    private static Hashtable order = null;
    private static Hashtable associative = null;
    public static final int DONT_LOOKUP_SYMBOLS = 1;
    public static final int NORMAL = 0;

    public InfixExpression(SymbolTable ls, SymbolTable st, Node parseTree, int mode) throws Exception {
        if (map == null || order == null || associative == null) {
            InfixExpression.initMaps();
        }
        this.symbolTable = st;
        this.localSymbols = ls;
        if (mode == 1) {
            this.lookupSymbols = false;
        }
        this.expression = this.genExpression(parseTree);
    }

    public InfixExpression(SymbolTable ls, SymbolTable st, Node parseTree) throws Exception {
        this(ls, st, parseTree, 0);
    }

    public InfixExpression(SymbolTable ls, SymbolTable st, MathMLExpression mathML) throws Exception {
        this(ls, st, mathML.getExpression(), 0);
    }

    public InfixExpression(SymbolTable st, MathMLExpression mathML) throws Exception {
        this(new SymbolTable(), st, mathML);
    }

    public InfixExpression(SymbolTable st, Node parseTree) throws Exception {
        this(new SymbolTable(), st, parseTree, 0);
    }

    public InfixExpression(MathMLExpression mathML) throws Exception {
        this(new SymbolTable(), new SymbolTable(), mathML);
    }

    public InfixExpression(Node parseTree) throws Exception {
        this(new SymbolTable(), new SymbolTable(), parseTree, 0);
    }

    public InfixExpression(Node parseTree, int mode) throws Exception {
        this(new SymbolTable(), new SymbolTable(), parseTree, mode);
    }

    private static void initMaps() {
        map = new Hashtable(100);
        map.put("true", "1>0");
        map.put("false", "0>1");
        map.put("eq", "==");
        map.put("neq", "!=");
        map.put("gt", ">");
        map.put("lt", "<");
        map.put("geq", ">=");
        map.put("leq", "<=");
        map.put("divide", "/");
        map.put("power", "^");
        map.put("and", "&");
        map.put("or", "|");
        map.put("times", "*");
        map.put("plus", "+");
        map.put("minus", "-");
        map.put("not", "NOT");
        map.put("abs", "abs");
        map.put("exp", "exp");
        map.put("ln", "log");
        map.put("floor", "flr");
        map.put("ceiling", "flr");
        map.put("sin", "sin");
        map.put("cos", "cos");
        map.put("tan", "tan");
        map.put("csc", "1/sin");
        map.put("sec", "1/cos");
        map.put("cot", "1/tan");
        map.put("csch", "1/sinh");
        map.put("sech", "1/cosh");
        map.put("coth", "1/tanh");
        map.put("sinh", "sinh");
        map.put("cosh", "cosh");
        map.put("tanh", "tanh");
        map.put("arcsin", "asin");
        map.put("arccos", "acos");
        map.put("arctan", "atan");
        map.put("arccsc", "asin");
        map.put("arcsec", "acos");
        map.put("arccot", "atan");
        map.put("arcsinh", "log");
        map.put("arccosh", "log");
        map.put("arctanh", "0.5*log");
        map.put("arccsch", "log");
        map.put("arcsech", "log");
        map.put("arccoth", "0.5*log");
        map.put("exponentiale", "exp(1)");
        map.put("pi", "pi");
        order = new Hashtable(30);
        order.put("power", new Integer(1));
        order.put("times", new Integer(2));
        order.put("divide", new Integer(2));
        order.put("plus", new Integer(3));
        order.put("minus", new Integer(3));
        order.put("eq", new Integer(4));
        order.put("neq", new Integer(4));
        order.put("gt", new Integer(4));
        order.put("lt", new Integer(4));
        order.put("geq", new Integer(4));
        order.put("leq", new Integer(4));
        order.put("not", new Integer(5));
        order.put("and", new Integer(6));
        order.put("or", new Integer(7));
        order.put("xor", new Integer(6));
        associative = new Hashtable(12);
        associative.put(new Integer(1), new Boolean(true));
        associative.put(new Integer(2), new Boolean(false));
        associative.put(new Integer(3), new Boolean(false));
        associative.put(new Integer(4), new Boolean(false));
        associative.put(new Integer(5), new Boolean(true));
        associative.put(new Integer(6), new Boolean(true));
        associative.put(new Integer(7), new Boolean(true));
    }

    public static void modifyMap(String function, String targetFunction) throws Exception {
        if (map == null) {
            InfixExpression.initMaps();
        }
        if (!map.containsKey(function)) {
            throw new Exception("function " + function + " does not exist in map.");
        }
        map.put(function, targetFunction);
    }

    private ArrayList genExpression(Node current) throws Exception {
        ArrayList<String> retArray = new ArrayList<String>();
        String name = current.getSimpleName().toLowerCase();
        if (name.equals("cn")) {
            retArray.add(current.getValue());
            return retArray;
        }
        if (name.equals("ci")) {
            String sym;
            String value = current.getValue();
            String string = sym = this.lookupSymbols ? this.localSymbols.lookupSymbolById(value) : value;
            if (sym == null && !this.lookupSymbols) {
                throw new Exception("Symbol not looked up and null.");
            }
            if (sym == null) {
                sym = this.symbolTable.lookupSymbolById(value);
            }
            if (sym == null) {
                throw new Exception("Symbol not found: '" + value + "'");
            }
            retArray.add(sym);
            return retArray;
        }
        if (name.matches("true|false|exponentiale|pi")) {
            retArray.add((String)map.get(name));
            return retArray;
        }
        if (name.equals("xor")) {
            ArrayList leftChild = this.genExpression(current.getChild(0));
            ArrayList rightChild = this.genExpression(current.getChild(1));
            int opPrec = (Integer)order.get(name);
            Integer temp = (Integer)order.get(current.getChild(0).getSimpleName().toLowerCase());
            if (temp != null && temp > opPrec) {
                leftChild.add(0, "(");
                leftChild.add(")");
            }
            if ((temp = (Integer)order.get(current.getChild(1).getSimpleName().toLowerCase())) != null && (temp > opPrec || temp == opPrec && !((Boolean)associative.get(temp)).booleanValue())) {
                rightChild.add(0, "(");
                rightChild.add(")");
            }
            retArray.add("(");
            retArray.addAll(leftChild);
            retArray.add(") & (NOT (");
            retArray.addAll(rightChild);
            retArray.add(")) | (");
            retArray.addAll(rightChild);
            retArray.add(") & (NOT (");
            retArray.addAll(leftChild);
            retArray.add("))");
            return retArray;
        }
        if (name.matches("eq|neq|gt|lt|geq|leq|divide|power|and|or|times|plus") || name.equals("minus") && current.getNumChildren() == 2) {
            String op = (String)map.get(name);
            ArrayList leftChild = this.genExpression(current.getChild(0));
            ArrayList rightChild = this.genExpression(current.getChild(1));
            int opPrec = (Integer)order.get(name);
            Integer temp = (Integer)order.get(current.getChild(0).getSimpleName().toLowerCase());
            if (temp != null && temp > opPrec) {
                leftChild.add(0, "(");
                leftChild.add(")");
            }
            if ((temp = (Integer)order.get(current.getChild(1).getSimpleName().toLowerCase())) != null && (temp > opPrec || temp == opPrec && !((Boolean)associative.get(temp)).booleanValue())) {
                rightChild.add(0, "(");
                rightChild.add(")");
            }
            retArray.addAll(leftChild);
            retArray.add(" " + op + " ");
            retArray.addAll(rightChild);
            return retArray;
        }
        if (name.equals("minus")) {
            int opPrec = (Integer)order.get(name);
            Integer temp = (Integer)order.get(current.getChild(0).getSimpleName().toLowerCase());
            ArrayList child = this.genExpression(current.getChild(0));
            if (temp != null && temp >= opPrec) {
                child.add(0, "(");
                child.add(")");
            }
            retArray.add((String)map.get(name));
            retArray.addAll(child);
            return retArray;
        }
        if (name.equals("root")) {
            double d = Double.parseDouble(current.getChild(1).getValue());
            if (d == 2.0) {
                retArray.add("sqrt(");
                retArray.addAll(this.genExpression(current.getChild(0)));
                retArray.add(")");
            } else {
                retArray.add("(");
                retArray.addAll(this.genExpression(current.getChild(0)));
                retArray.add(")^(1/" + d + ")");
            }
            return retArray;
        }
        if (name.equals("ln")) {
            retArray.add("(" + map.get("ln") + "(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))");
            return retArray;
        }
        if (name.equals("log")) {
            int n = Integer.parseInt(current.getChild(0).getValue());
            if (n == 10) {
                retArray.add("log10(");
                retArray.addAll(this.genExpression(current.getChild(1)));
                retArray.add(")");
            } else {
                retArray.add("(log(");
                retArray.addAll(this.genExpression(current.getChild(1)));
                retArray.add(")/log(");
                retArray.add(String.valueOf(n));
                retArray.add("))");
            }
            return retArray;
        }
        if (name.equals("not")) {
            String op = (String)map.get(name);
            int opPrec = (Integer)order.get(name);
            Integer temp = (Integer)order.get(current.getChild(0).getSimpleName().toLowerCase());
            ArrayList child = this.genExpression(current.getChild(0));
            if (temp != null && temp > opPrec) {
                child.add(0, "(");
                child.add(")");
            }
            retArray.add(op);
            retArray.addAll(child);
            return retArray;
        }
        if (name.matches("abs|exp|floor|sin|cos|tan|sinh|cosh|tanh|csc|sec|cot|csch|sech|coth|arcsin|arccos|arctan")) {
            retArray.add((String)map.get(name));
            retArray.add("(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")");
            return retArray;
        }
        if (name.equals("ceiling")) {
            retArray.add((String)map.get(name));
            retArray.add("(0.9999999+");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")");
            return retArray;
        }
        if (name.matches("arccsc|arcsec|arccot")) {
            retArray.add((String)map.get(name));
            retArray.add("(1/(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))");
            return retArray;
        }
        if (name.equals("function")) {
            String sym;
            String value = current.getValue();
            String string = sym = this.lookupSymbols ? this.localSymbols.lookupSymbolById(value) : value;
            if (sym == null && !this.lookupSymbols) {
                throw new Exception("Symbol not looked up and null.");
            }
            String string2 = sym = sym == null ? this.symbolTable.lookupSymbolById(value) : sym;
            if (sym == null) {
                throw new Exception("Symbol not found: " + value);
            }
            ArrayList<String> args = new ArrayList<String>();
            int numChildren = current.getNumChildren();
            for (int i = 0; i < numChildren; ++i) {
                if (i != 0) {
                    args.add(",");
                }
                args.addAll(this.genExpression(current.getChild(i)));
            }
            retArray.add(sym);
            retArray.add("(");
            retArray.addAll(args);
            retArray.add(")");
            return retArray;
        }
        if (name.equals("piecewise")) {
            if (current.getNumChildren() > 2) {
                throw new Exception("Only if then else is supported");
            }
            retArray.add("if (");
            retArray.addAll(this.genExpression(current.getChild(0).getChild(1)));
            retArray.add(") then (");
            retArray.addAll(this.genExpression(current.getChild(0).getChild(0)));
            retArray.add(") else (");
            retArray.addAll(this.genExpression(current.getChild(1).getChild(0)));
            retArray.add(")");
            return retArray;
        }
        if (name.equals("arcsinh")) {
            retArray.add((String)map.get(name));
            retArray.add("((");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")+((");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")^2+1)^0.5)");
            return retArray;
        }
        if (name.equals("arccosh")) {
            retArray.add((String)map.get(name));
            retArray.add("((");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")+((");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")^2-1)^0.5)");
            return retArray;
        }
        if (name.equals("arctanh")) {
            retArray.add((String)map.get(name));
            retArray.add("((1+(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))/(1-(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")))");
            return retArray;
        }
        if (name.equals("arcsech")) {
            retArray.add((String)map.get(name));
            retArray.add("((1+(1-(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")^2)^0.5)/(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))");
            return retArray;
        }
        if (name.equals("arccsch")) {
            retArray.add((String)map.get(name));
            retArray.add("((1+(1+(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")^2)^0.5)/(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))");
            return retArray;
        }
        if (name.equals("arccoth")) {
            retArray.add((String)map.get(name));
            retArray.add("((1+(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))/((");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")-1))");
            return retArray;
        }
        if (name.equals("factorial")) {
            retArray.add("((2*(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")+1/3)*pi)^0.5*(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")^(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add(")*exp(-(");
            retArray.addAll(this.genExpression(current.getChild(0)));
            retArray.add("))");
            return retArray;
        }
        if (name.equals("csymbol")) {
            String symbol = current.getAttributes().getValue("definitionURL");
            if (symbol.equals("http://www.sbml.org/sbml/symbols/time")) {
                retArray.add("t");
                return retArray;
            }
            throw new Exception("Unsupported csymbol: " + symbol);
        }
        if (name.matches("nan|inf")) {
            throw new Exception(name + " not supported.");
        }
        throw new Exception("should never throw this, but did for " + name);
    }

    public Integer getOrder(Node node) throws Exception {
        String sym;
        String simpleName = node.getSimpleName().toLowerCase();
        if (!simpleName.equals("function")) {
            return (Integer)order.get(simpleName);
        }
        String value = node.getValue();
        String string = sym = this.lookupSymbols ? this.localSymbols.lookupSymbolById(value) : value;
        if (sym == null && !this.lookupSymbols) {
            throw new Exception("Symbol not looked up and null.");
        }
        String string2 = sym = sym == null ? this.symbolTable.lookupSymbolById(value) : sym;
        if (sym == null) {
            throw new Exception("Symbol not found: " + value);
        }
        return (Integer)order.get(sym);
    }

    public static String mergeExpression(ArrayList expression, String indent, int width, String prefix) {
        String curLine = "";
        if (prefix != null) {
            curLine = prefix;
        }
        Iterator i = expression.iterator();
        while (i.hasNext()) {
            String curToken = (String)i.next();
            curLine = curLine + curToken;
        }
        return curLine;
    }

    public String getExpression() {
        return InfixExpression.mergeExpression(this.expression, "", 80, "");
    }

    public String getExpression(String indent, int width) {
        return InfixExpression.mergeExpression(this.expression, indent, width, "");
    }

    public String getExpression(String indent, int width, String prefix) {
        return InfixExpression.mergeExpression(this.expression, indent, width, prefix);
    }
}

