/*
 * Decompiled with CFR 0.152.
 */
package jigcell.sbml2.tests;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import jigcell.sbml2.Compartment;
import jigcell.sbml2.FunctionDefinition;
import jigcell.sbml2.Model;
import jigcell.sbml2.ModifierSpeciesReference;
import jigcell.sbml2.Parameter;
import jigcell.sbml2.Reaction;
import jigcell.sbml2.SBMLLevel2Document;
import jigcell.sbml2.Species;
import jigcell.sbml2.SpeciesReference;
import jigcell.sbml2.Unit;
import jigcell.sbml2.UnitDefinition;
import junit.framework.TestCase;

abstract class SBMLModelTests
extends TestCase {
    protected boolean cycle = false;
    protected Model model;
    protected String modelName = null;

    public SBMLModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        SBMLLevel2Document document = SBMLLevel2Document.readDocument(SBMLModelTests.class.getResourceAsStream(this.modelName));
        this.model = document.getModel();
        if (!this.cycle) {
            return;
        }
        this.modelName = "x-" + this.modelName;
        document.writeDocument(new BufferedWriter(new FileWriter(this.modelName)));
        this.model = SBMLLevel2Document.readDocument(this.modelName).getModel();
    }

    protected Compartment testCompartment(String name, boolean constant, String outside, double size, int dimensions, String units) {
        Iterator iterator = this.model.getCompartments().iterator();
        while (iterator.hasNext()) {
            Compartment compartment = (Compartment)iterator.next();
            if (!compartment.getName().equals(name)) continue;
            SBMLModelTests.assertTrue((compartment.isConstant() == constant ? 1 : 0) != 0);
            SBMLModelTests.assertTrue((boolean)this.stringEquals(compartment.getOutside(), outside));
            SBMLModelTests.assertTrue((size == compartment.getSize() || Double.isNaN(size) && Double.isNaN(compartment.getSize()) ? 1 : 0) != 0);
            SBMLModelTests.assertTrue((dimensions == compartment.getSpatialDimensions() ? 1 : 0) != 0);
            SBMLModelTests.assertTrue((boolean)this.stringEquals(compartment.getUnits(), units));
            return compartment;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected FunctionDefinition testFunctionDefinition(String name) {
        Iterator iterator = this.model.getFunctionDefinitions().iterator();
        while (iterator.hasNext()) {
            FunctionDefinition definition = (FunctionDefinition)iterator.next();
            if (!definition.getName().equals(name)) continue;
            return definition;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected Parameter testParameter(String name, double value) {
        return this.testParameter(this.model.getParameters().iterator(), name, value, null, true);
    }

    protected Parameter testParameter(String name, double value, String unit, boolean constant) {
        return this.testParameter(this.model.getParameters().iterator(), name, value, unit, constant);
    }

    protected Parameter testParameter(Reaction reaction, String name, double value) {
        return this.testParameter(reaction.getKineticLaw().getParameter().iterator(), name, value, null, true);
    }

    protected Reaction testReaction(String name, Boolean fast, boolean reversible) {
        Iterator iterator = this.model.getReactions().iterator();
        while (iterator.hasNext()) {
            Reaction reaction = (Reaction)iterator.next();
            if (!reaction.getName().equals(name)) continue;
            if (fast == null) {
                SBMLModelTests.assertTrue((!reaction.isFastSet() ? 1 : 0) != 0);
            } else {
                SBMLModelTests.assertTrue((boolean)reaction.isFastSet());
                SBMLModelTests.assertTrue((reaction.isFast() == fast.booleanValue() ? 1 : 0) != 0);
            }
            SBMLModelTests.assertTrue((reaction.isReversible() == reversible ? 1 : 0) != 0);
            return reaction;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected ModifierSpeciesReference testReactionModifier(List modifiers, String name) {
        Iterator iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            ModifierSpeciesReference reference = (ModifierSpeciesReference)iterator.next();
            if (!reference.getSpecies().equals(name)) continue;
            return reference;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected SpeciesReference testReactionModifier(List modifiers, String name, double stoichiometry) {
        Iterator iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            SpeciesReference reference = (SpeciesReference)iterator.next();
            if (!reference.getSpecies().equals(name)) continue;
            SBMLModelTests.assertTrue((stoichiometry == reference.getStoichiometry() ? 1 : 0) != 0);
            return reference;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected Species testSpecies(String name, String compartment, double initialConcentration, boolean constant, boolean boundaryCondition) {
        Iterator iterator = this.model.getSpecies().iterator();
        while (iterator.hasNext()) {
            Species species = (Species)iterator.next();
            if (!species.getName().equals(name)) continue;
            SBMLModelTests.assertTrue((boolean)this.stringEquals(species.getCompartment(), compartment));
            SBMLModelTests.assertTrue((boolean)this.doubleEquals(species.getInitialConcentration(), initialConcentration));
            SBMLModelTests.assertTrue((species.isConstant() == constant ? 1 : 0) != 0);
            SBMLModelTests.assertTrue((species.isBoundaryCondition() == boundaryCondition ? 1 : 0) != 0);
            return species;
        }
        SBMLModelTests.fail();
        return null;
    }

    protected void testUnit(Unit unit, int exponent, String kindName, double multiplier, double offset, int scale) {
        SBMLModelTests.assertTrue((unit.getExponent() == exponent ? 1 : 0) != 0);
        SBMLModelTests.assertTrue((boolean)unit.getKindName().equals(kindName));
        SBMLModelTests.assertTrue((unit.getMultiplier() == multiplier ? 1 : 0) != 0);
        SBMLModelTests.assertTrue((unit.getOffset() == offset ? 1 : 0) != 0);
        SBMLModelTests.assertTrue((unit.getScale() == scale ? 1 : 0) != 0);
    }

    protected UnitDefinition testUnitDefinition(String name, int size) {
        Iterator iterator = this.model.getUnitDefinitions().iterator();
        while (iterator.hasNext()) {
            UnitDefinition definition = (UnitDefinition)iterator.next();
            if (!definition.getName().equals(name)) continue;
            SBMLModelTests.assertTrue((definition.getUnits().size() == size ? 1 : 0) != 0);
            return definition;
        }
        SBMLModelTests.fail();
        return null;
    }

    private boolean doubleEquals(double d1, double d2) {
        return d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2);
    }

    private boolean stringEquals(String s1, String s2) {
        return s1 == s2 || s1.equals(s2);
    }

    private Parameter testParameter(Iterator iterator, String name, double value, String unit, boolean constant) {
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.getName().equals(name)) continue;
            SBMLModelTests.assertTrue((boolean)this.doubleEquals(parameter.getValue(), value));
            SBMLModelTests.assertTrue((boolean)this.stringEquals(parameter.getUnits(), unit));
            SBMLModelTests.assertTrue((parameter.isConstant() == constant ? 1 : 0) != 0);
            return parameter;
        }
        SBMLModelTests.fail();
        return null;
    }
}

