/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Composite;
import java.awt.geom.GeneralPath;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.Region;

public class Win32D3DRenderer
extends Win32DDRenderer {
    boolean canHandleClipping = false;

    public Win32D3DRenderer(boolean bl) {
        this.canHandleClipping = bl;
    }

    native boolean doDrawLineD3D(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    native boolean doDrawRectD3D(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private boolean lineClipNeeded(Region region, int n, int n2, int n3, int n4) {
        int n5 = region.getLoX();
        int n6 = region.getLoY();
        int n7 = region.getHiX();
        int n8 = region.getHiY();
        return n < n5 || n3 < n5 || n >= n7 || n3 >= n7 || n2 < n6 || n4 < n6 || n2 >= n8 || n4 >= n8;
    }

    private boolean rectClipNeeded(Region region, int n, int n2, int n3, int n4) {
        return !region.encompassesXYWH(n, n2, n3 + 1, n4 + 1);
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (n == n3 || n2 == n4) {
            super.drawLine(sunGraphics2D, n, n2, n3, n4);
            return;
        }
        int n5 = n + sunGraphics2D.transX;
        int n6 = n2 + sunGraphics2D.transY;
        int n7 = n3 + sunGraphics2D.transX;
        int n8 = n4 + sunGraphics2D.transY;
        Region region = sunGraphics2D.getCompClip();
        if (!this.canHandleClipping && this.lineClipNeeded(region, n5, n6, n7, n8)) {
            super.drawLine(sunGraphics2D, n, n2, n3, n4);
            return;
        }
        if (!this.doDrawLineD3D(sunGraphics2D.surfaceData, sunGraphics2D.rgb, n5, n6, n7, n8, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY())) {
            ((Win32OffScreenSurfaceData)sunGraphics2D.surfaceData).disableD3D();
            sunGraphics2D.validatePipe();
            super.drawLine(sunGraphics2D, n, n2, n3, n4);
        }
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        if (n3 == 0 || n4 == 0) {
            this.drawLine(sunGraphics2D, n, n2, n + n3, n2 + n4);
            return;
        }
        int n5 = n + sunGraphics2D.transX;
        int n6 = n2 + sunGraphics2D.transY;
        Region region = sunGraphics2D.getCompClip();
        if (!this.canHandleClipping && this.rectClipNeeded(region, n5, n6, n3, n4)) {
            super.drawRect(sunGraphics2D, n, n2, n3, n4);
            return;
        }
        if (!this.doDrawRectD3D(sunGraphics2D.surfaceData, sunGraphics2D.rgb, n5, n6, n3, n4, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY())) {
            ((Win32OffScreenSurfaceData)sunGraphics2D.surfaceData).disableD3D();
            sunGraphics2D.validatePipe();
            super.drawRect(sunGraphics2D, n, n2, n3, n4);
        }
    }

    public Win32D3DRenderer traceWrapD3D() {
        return new Tracer(this.canHandleClipping);
    }

    public static class Tracer
    extends Win32D3DRenderer {
        Tracer(boolean bl) {
            super(bl);
        }

        void doDrawLine(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawLine");
            super.doDrawLine(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRect");
            super.doDrawRect(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawRoundRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRoundRect");
            super.doDrawRoundRect(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doDrawOval(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawOval");
            super.doDrawOval(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawArc(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawArc");
            super.doDrawArc(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doDrawPoly(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("GDIDrawPoly");
            super.doDrawPoly(surfaceData, region, composite, n, n2, n3, nArray, nArray2, n4, bl);
        }

        void doFillRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("DDFillRect");
            super.doFillRect(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doFillRoundRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillRoundRect");
            super.doFillRoundRect(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doFillOval(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillOval");
            super.doFillOval(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doFillArc(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillArc");
            super.doFillArc(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doFillPoly(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
            GraphicsPrimitive.tracePrimitive("GDIFillPoly");
            super.doFillPoly(surfaceData, region, composite, n, n2, n3, nArray, nArray2, n4);
        }

        void doShape(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, GeneralPath generalPath, boolean bl) {
            GraphicsPrimitive.tracePrimitive(bl ? "GDIFillShape" : "GDIDrawShape");
            super.doShape(surfaceData, region, composite, n, n2, n3, generalPath, bl);
        }

        void devCopyArea(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDICopyArea");
            super.devCopyArea(surfaceData, n, n2, n3, n4, n5, n6);
        }

        boolean doDrawLineD3D(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            GraphicsPrimitive.tracePrimitive("D3DDrawLine");
            return super.doDrawLineD3D(surfaceData, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }

        void doFillRectDD(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("DDFillRect");
            super.doFillRectDD(surfaceData, n, n2, n3, n4, n5);
        }

        boolean doDrawRectD3D(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            GraphicsPrimitive.tracePrimitive("D3DDrawRect");
            return super.doDrawRectD3D(surfaceData, n, n2, n3, n4, n5, n6, n7, n8, n9);
        }
    }
}

