/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Composite;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.LoopPipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Win32Renderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe {
    private static native void initIDs();

    native void doDrawLine(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        int n5 = sunGraphics2D.transX;
        int n6 = sunGraphics2D.transY;
        this.doDrawLine(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + n5, n2 + n6, n3 + n5, n4 + n6);
    }

    native void doDrawRect(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.doDrawRect(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    native void doDrawRoundRect(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doDrawRoundRect(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
    }

    native void doDrawOval(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.doDrawOval(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    native void doDrawArc(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doDrawArc(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
    }

    native void doDrawPoly(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int[] var7, int[] var8, int var9, boolean var10);

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doDrawPoly(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, false);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doDrawPoly(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n, true);
    }

    native void doFillRect(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.doFillRect(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    native void doFillRoundRect(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doFillRoundRect(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
    }

    native void doFillOval(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8);

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.doFillOval(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4);
    }

    native void doFillArc(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.doFillArc(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n + sunGraphics2D.transX, n2 + sunGraphics2D.transY, n3, n4, n5, n6);
    }

    native void doFillPoly(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, int[] var7, int[] var8, int var9);

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.doFillPoly(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, sunGraphics2D.transX, sunGraphics2D.transY, nArray, nArray2, n);
    }

    native void doShape(SurfaceData var1, Region var2, Composite var3, int var4, int var5, int var6, GeneralPath var7, boolean var8);

    void doShape(SunGraphics2D sunGraphics2D, Shape shape, boolean bl) {
        GeneralPath generalPath;
        int n;
        int n2;
        if (shape instanceof GeneralPath) {
            if (sunGraphics2D.transformState >= 3) {
                shape = ((GeneralPath)shape).createTransformedShape(sunGraphics2D.transform);
                n2 = 0;
                n = 0;
            } else {
                n2 = sunGraphics2D.transX;
                n = sunGraphics2D.transY;
            }
            generalPath = (GeneralPath)shape;
        } else {
            PathIterator pathIterator = shape.getPathIterator(sunGraphics2D.transform);
            generalPath = new GeneralPath(pathIterator.getWindingRule());
            generalPath.append(pathIterator, false);
            n2 = 0;
            n = 0;
        }
        this.doShape(sunGraphics2D.surfaceData, sunGraphics2D.getCompClip(), sunGraphics2D.composite, sunGraphics2D.rgb, n2, n, generalPath, bl);
    }

    public void doFillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        int[] nArray = new int[4];
        SurfaceData surfaceData = sunGraphics2D.surfaceData;
        Region region = sunGraphics2D.getCompClip();
        Composite composite = sunGraphics2D.composite;
        int n = sunGraphics2D.rgb;
        while (spanIterator.nextSpan(nArray)) {
            this.doFillRect(surfaceData, region, composite, n, nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (sunGraphics2D.strokeState == 0) {
            this.doShape(sunGraphics2D, shape, false);
        } else if (sunGraphics2D.strokeState < 3) {
            ShapeSpanIterator shapeSpanIterator = LoopPipe.getStrokeSpans(sunGraphics2D, shape);
            try {
                this.doFillSpans(sunGraphics2D, shapeSpanIterator);
            }
            finally {
                shapeSpanIterator.dispose();
            }
        } else {
            this.doShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true);
        }
    }

    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.doShape(sunGraphics2D, shape, true);
    }

    native void devCopyArea(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Win32Renderer traceWrap() {
        return new Tracer();
    }

    static {
        Win32Renderer.initIDs();
    }

    public static class Tracer
    extends Win32Renderer {
        void doDrawLine(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawLine");
            super.doDrawLine(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRect");
            super.doDrawRect(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawRoundRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawRoundRect");
            super.doDrawRoundRect(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doDrawOval(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIDrawOval");
            super.doDrawOval(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doDrawArc(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIDrawArc");
            super.doDrawArc(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doDrawPoly(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("GDIDrawPoly");
            super.doDrawPoly(surfaceData, region, composite, n, n2, n3, nArray, nArray2, n4, bl);
        }

        void doFillRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillRect");
            super.doFillRect(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doFillRoundRect(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillRoundRect");
            super.doFillRoundRect(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doFillOval(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5) {
            GraphicsPrimitive.tracePrimitive("GDIFillOval");
            super.doFillOval(surfaceData, region, composite, n, n2, n3, n4, n5);
        }

        void doFillArc(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            GraphicsPrimitive.tracePrimitive("GDIFillArc");
            super.doFillArc(surfaceData, region, composite, n, n2, n3, n4, n5, n6, n7);
        }

        void doFillPoly(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, int[] nArray, int[] nArray2, int n4) {
            GraphicsPrimitive.tracePrimitive("GDIFillPoly");
            super.doFillPoly(surfaceData, region, composite, n, n2, n3, nArray, nArray2, n4);
        }

        void doShape(SurfaceData surfaceData, Region region, Composite composite, int n, int n2, int n3, GeneralPath generalPath, boolean bl) {
            GraphicsPrimitive.tracePrimitive(bl ? "GDIFillShape" : "GDIDrawShape");
            super.doShape(surfaceData, region, composite, n, n2, n3, generalPath, bl);
        }

        void devCopyArea(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("GDICopyArea");
            super.devCopyArea(surfaceData, n, n2, n3, n4, n5, n6);
        }
    }
}

