import nsrunit;
unit conversion on;

math COMPvsDIST { // 2 compartment model

/* Diagram

 F(flow)      _____________________________
 Cin(t) ---> |                        C1(t)|---> Cout(t)=C1(t)
             | V1(volume)                  |
             | instantaneously well mixed  |
             |             ^               |
             |____________PS_______________|
             |             v               |
             | V2(volume)             C2(t)|
             | instantaneously well mixed  |
             |_____________________________|
*/


// independent variable will be t (time)
realDomain t sec; t.min=0; t.max=30; t.delta=0.1; 

// Parameters and variables
real C1(t) M, C2(t) M, Cout(t) M;   // Concentrations 
real V1= 0.05 ml, V2 = 0.15 ml;     // Volumes (ml)
real F= 1 ml/min, PS = 3.0 ml/min; // Flow and Exchange rates

extern real Cin(t) M;               // Inflow concentration

//Initial Conditions
when(t=t.min) {C1=0; C2=0;}
/* The ordinary differential equations (ODE's) for
   Mass Balance can be written either as
   V1*C1:t = F*(Cin-C1) + PS*(C2-C1); and
   V2*C2:t =            - PS*(C2-C1); or more usually as 
*/
C1:t = F/V1*(Cin-C1) + PS/V1*(C2-C1);
C2:t =                -PS/V2*(C2-C1);
// The outflow, Cout is C1 because compartments are 
// instantaneously well mixed.
Cout=C1;














/* Diagram

 F(flow)      _____________________________
 Cin(t) ---> |                        C1(t)|---> Cout(t)=C1(t)
             | V1(volume)                  |
             |     <-Diff1-> diffusion     |
             |             ^               |
             |____________PS_______________|
             |             v               |
             |     <-Diff2-> diffusion
             | V2(volume)             C2(t)|
             |_____________________________|
             |<-      0 <=x<= L          ->|

*/



//-------------------------------------------------------------
// Distributed 2 region model (Advection-Diffusion)

real L=0.1 cm;                      // Length of region
real Ngrid=61;                      // Number of grid points

// x is a second independent variable
realDomain x cm; x.min=0; x.max=L; x.ct = Ngrid;
real D1(x,t) M, D2(x,t) M, Dout(t);           // Concentrations
real Diff1 = 1e-5 cm^2/sec, Diff2 = 1e-5 cm^2/sec;  // Diffusion coeffs

// Boundary Conditions
when (x=x.min) {D1=Cin;          D2:x=0;}
when (x=x.max) {D1:x=0; Dout=D1; D2:x=0;}

// Initial Conditions
when(t=t.min) { D1 = if (x=x.min) Cin else 0; D2=0; }

// Partial Differential Equations (Diffusion-Advection)
D1:t = -F*L/V1*D1:x + PS/V1*(D2-D1) + Diff1*D1:x:x;
D2:t =              - PS/V2*(D2-D1) + Diff1*D2:x:x;

/* WHY -F*L/V1*D1:x ? Think (F/V1)*L a velocity TIMES (-D1:x)
   the negative of the gradient.

   Consider the crude gradient approximation using values of
   the concentrations at the endpoints:

         D(L)-D(0)    Dout-Cin
  D1:x= ---------  = ------------ = (Dout-Cin)/L
            L-0          L

   Substituting
   -F*L/V1*D1:x=-F*L/V1*(Dout-Cin)/L = F/V1*(Cin-Dout)
  
   Same as the compartment formulation

*/
}
