import nsrunit;       // imports unit file
unit conversion on;   // unit balance checking
math Comp1Flow {      // 1 compartment model with flow
/* Diagram

 F(flow)      _____________________________
 Cin(t) ---> |                        C1(t)|---> Cout(t)=C1(t)
             | V1(volume)                  |
             | instantaneously well mixed  |
             |_____________________________|
*/
// independent variable will be t (time)
realDomain t sec; t.min=0; t.max=30; t.delta=0.1; 

// Parameters and variables
real C1(t) mM;                             // Concentration 
real C10 = 0 mM;                           // Initial Concentration 
extern real Cin(t) mM;                     // Inflow concentration
real Cout(t) mM;                           // Outflow Concentration
real V1 = 0.05 ml,                         // Volume  
     F  = 1 ml/min                       // Flow 
 
// Initial Condition
when(t=t.min) {C1=C10;}           

// The ordinary differential equation (ODE) 
C1:t = F/V1*(Cin-C1) ;

/* Outflow concentration equals compartment concentration
   because compartments are instantaneously well mixed.   */
Cout=C1;

//Additional Calculations
real Q(t) mmol, Qint(t) mmol; when (t=t.min) {Qint=V1*C10;}
Q=V1*C1;
Qint:t=F*(Cin-Cout);

}
