function AdaptExc;
%function Par= AdaptExc(Par);
% Simulates adaptation of vessels and chambers to current hemodynamics
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

global Par
save ParTemp Par; %saves intermediate solution

%=== ERROR criterium on flow stationarity
% FlowVec= mean([Par.ValveRVen.q,Par.ValveRAv.q,Par.ValveRArt.q,...
%     Par.ValveLVen.q,Par.ValveLAv.q,Par.ValveLArt.q]);
FlowVec= mean([Par.ValveRVen.q,Par.ValveRArt.q,...
    Par.ValveLVen.q,Par.ValveLArt.q]);
if isfield(Par.Specific, 'FlowVec')
    FlowVecPrev= Par.Specific.FlowVec;
    if length(FlowVecPrev)~=length(FlowVec);
        FlowVecPrev= 0*FlowVec;
    end
else
    FlowVecPrev= 0*FlowVec;
end
ErrFlow= std(FlowVec-FlowVecPrev)/mean(FlowVec);
Par.Specific.FlowVec= FlowVec;
disp(['Flow RVen RAv RArt LVen LAv LArt Err (ml/s), ErrFlow :']);
disp([num2str([FlowVec*1e6,ErrFlow],4)]);
%=== end flow error calculation

if ErrFlow<0.05;
    %=== Adapt tube wall thickness
    Par.TubeLArt= TubeAdapt(Par.TubeLArt,{'WallVolume'});
    Par.TubeRArt= TubeAdapt(Par.TubeRArt,{'WallVolume'});
    Par.TubeLVen= TubeAdapt(Par.TubeLVen,{'WallVolume'});
    Par.TubeRVen= TubeAdapt(Par.TubeRVen,{'WallVolume'});
    
    %=== Adapt sheet properties
    [Par.Lv,ELv]= SheetAdapt(Par.Lv,{'WallVolume','WallArea','SarcLength'});
    [Par.Sv,ESv]= SheetAdapt(Par.Sv,{'WallVolume','WallArea','SarcLength'});
    [Par.Rv,ERv]= SheetAdapt(Par.Rv,{'WallVolume','WallArea','SarcLength'});
    [Par.La,ELa]= SheetAdapt(Par.La,{'WallVolume','WallArea','SarcLength'});
    [Par.Ra,ERa]= SheetAdapt(Par.Ra,{'WallVolume','WallArea','SarcLength'});
    
    ErrSheet=mean([ELv,ESv,ERv,ELa,ERa]);
    
    disp(['VWall(ml)= ',num2str( 1e6*(Par.Lv.VWall+Par.Sv.VWall) )]);
    disp(['ErrSheet = ',num2str( ErrSheet )]);
    
    %=== If steady state -> end of adaptation
    if (ErrFlow<0.01) & (ErrSheet<0.001); % Escape if steady state is reached
        Par.General.tEnd= Par.General.tEnd-0.5*(Par.General.tEnd-Par.t(end));
    end
    %----------
end

%=== make ready for next beat
Par2SVar;
SVarDot= CircSVarDot(0,Par.SVar(end,:)',[]);
return