function AdaptRest;
%function Par= AdaptRest(Par);
% Simulates adaptation of vessels and chambers to current hemodynamics
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

global Par
save ParTemp Par; %saves intermediate solution

%=== ERROR criterium on flow stationarity
FlowVec= mean([Par.ValveRVen.q,Par.ValveRArt.q,...
    Par.ValveLVen.q,Par.ValveLArt.q]);
if isfield(Par.Specific, 'FlowVec')
    FlowVecPrev= Par.Specific.FlowVec;
else
    FlowVecPrev= zeros(size(FlowVec));
end
ErrFlow= std(FlowVec-FlowVecPrev)/mean(FlowVec);
Par.Specific.FlowVec= FlowVec;
disp(['Flow RVen RArt LVen LArt Err (ml/s), ErrFlow :']);
disp([num2str([FlowVec*1e6,ErrFlow])]);
%----

%=== Carrying ou adaptation
if (ErrFlow<0.05); % Adaptation only if ErrFlow indicates 'stationarity'
    %=== Adapt tube diameters
    Par.TubeLArt= TubeAdapt(Par.TubeLArt,{'Diameter'});
    Par.TubeRArt= TubeAdapt(Par.TubeRArt,{'Diameter'});
    Par.TubeLVen= TubeAdapt(Par.TubeLVen,{'Diameter'});
    Par.TubeRVen= TubeAdapt(Par.TubeRVen,{'Diameter'});
end
%---

%=== If steady state -> end of adaptation
if ErrFlow<0.003; % Escape if steady state is reached
    Par.General.tEnd= Par.General.tEnd-0.5*(Par.General.tEnd-Par.t(end));
end

%=== make ready for next beat
Par2SVar;
SVarDot= CircSVarDot(0,Par.SVar(end,:)',[]);

return
