function Cavity= CavityMech(Cavity);
% function Cavity= CavityMech(Cavity);
% Cavity volume -> Cavity pressure
% Structure Cavity.
%       Sarc: [1x1 struct]  : Changed Sarcomere, may contain many patches
%      AmRef: 0.0120        : In      Area with Sarc.Ls=LsRef
%      VWall: 1.0658e-004   : In      Wall volume
%          V: [851x1 double]: In      Cavity volume
%       VDot: [851x1 double]
%         Vm: [851x1 double]
%         Xm: [851x1 double]
%         Ym: [851x1 double]
%         Am: [851x1 double]: Changed Wall area
%         Cm: [851x1 double]: Changed Wall curvature
%          T: [851x1 double]: Changed Wall tension
%     pTrans: [851x1 double]: Changed Transmural pressure
%      DTDAm: [851x1 double]: Changed Wall stiffness
%          p: [851x1 double]: Changed Cavity pressure
%          A: [851x1 double]: Changed Cavity short axis cross-section
%          Z: 0             : Changed Impedance between pIn and p
%        pIn: [851x1 double]: Changed External hemodynamic pressure
%     qRemod: [851x1 double]: Changed Flow used for diameter adaptation
%          Y: []
%       YDot: []
%        Tau: []
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

% Collecting input
rhob = 1050;
VWall= Cavity.VWall; % wall volume
V    = max(Cavity.V,0);     % cavity volume
AmRef= Cavity.AmRef; % reference area with Ls=LsRef (=2um)

% Segment mechanics full sphere
Vm= V+0.5*VWall;           % mid-wall enclosed volume
Cm= (4*pi./(3*Vm)).^(1/3); % curvature=1/radius
AmTot= (4*pi)./Cm.^2;         % mid-wall surface area
Cavity.Am= AmTot - Cavity.AmDead;
Cavity.Cm= Cm;

% Cavity as Sheet is encapsulating the cavity
Cavity= SheetMech(Cavity); % 2D-sheet Am,Cm,VWall,AmRef-> T,

Len= 2* Vm.^(1/3)              ; % estimate of long-axis length LV
A  = (V+0.1*VWall) ./Len       ; % crude estimate of cross-section of a (left) ventricle


% Estimate of tube properties for wave guidance
Cavity.p    = Cavity.pTrans   ; % cavity pressure, assuming pExternal=0
Cavity.A    = A               ; % cross-sectional area for valve inflow and outflow pressure
Cavity.Z    = 0               ; % Compatibitlity with Tube

% Initializations
Cavity.pIn   = Cavity.p;
Cavity.VDot  = 0;
Cavity.qRemod= 0;