function CircAdapt
% function Par= CircAdapt(Par);
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% === Solution of differential equations, defined in global structure 'Par'
% Solution of state variables stored in Par.SVar

global Par

% Timing and setting start condition of state variables
Timing; %sets arrays of activation times for sarcomeres
Par.SVar=[];
Par2SVar; Par.SVar=Par.SVar(:,end);

% load general parameters
tCycle      = Par.General.tCycle;
Dt          = Par.General.Dt;
DtSimulation= Par.General.DtSimulation;

% solving differential equations
Par2SVar; % setting initial condition of differential equation in Par.SVar

SVar= Par.SVar(end,:); % sets start condition
% Right atriual activation used as start of heart cycle
tRa= Par.Ra.Sarc.ActivationDelay;
Rg = find(tRa>Par.t(end)+Dt); % select relevant RA-triggers
tRa=tRa(Rg); iRa=1; nRa=length(tRa); % tRa=end points of beats
Par.General.tEnd= tRa(end);
while Par.t(end)<Par.General.tEnd-Dt;
    % Set simulation interval
    tStart=Par.t(end);
    nDt= ceil((tRa(iRa)-tStart)/Dt+1); % duration simulation > tRa(next)
    iRa=iRa+1;
    TimePoints= Dt*[0:nDt]; % time interval to be appended to the already
    % existing solution
    disp(['t= ',num2str(Par.t(end)),';  Time to go= ',...
        num2str(Par.General.tEnd-Par.t(end))]); pause(0.01);

    tol=1e-4; %tol= 1e-4 or 1e-5: trade off accuracy and calculation speed
    opt = odeset('RelTol',tol,'AbsTol',tol);
    [tDummy,SVarAppend]= ode113('CircSVarDot',...
        TimePoints,Par.SVar(end,:),opt); % solving of Differential Equations
    SVar= [SVar;SVarAppend(2:end,:)]; %appends 1-beat SVar-vector
    % SVarAppend(1) removed because of overlap with previous beat
    Par.SVar= SVarAppend;
    CircAdaptDisplay; % display and time course of 1-beat hemodynamics
    % Calculation of changes due to adaptation
    P= Par.Specific.Menu(Par.Specific.MenuNr);
    eval([P.NameAdapt,';']);% Carrying out adaptation function
    % Time courses in Par belong to parameter setting before Adapt-action!
end
Par.SVar= SVar; %state variables of all beats to show trends. Be careful,
% because AdaptXX has been applied, the Par-parameters do not belong to the
% Par.SVar. Only for MenuNr= 1, function Adapt0= no adaptation, complete SVar
% is compatible with parameter settings.

return
