function P=CircAdaptDisplay;
% function P= CircAdaptDisplay
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% Reads state variables from Par.SVar,
% makes graphical display of some variables

global Par

[SVarDot] = CircSVarDot(0,transpose(Par.SVar),[]);

P=Par;
% dependent variables as f(t)
q0          = Par.General.q0;
p0          = Par.General.p0;
DtSimulation= Par.General.DtSimulation;
tCycle      = Par.General.tCycle;
Dt          = Par.General.Dt;

% scaling of graphics
qSc= Rnd(q0);
VSc= Rnd(q0*tCycle/10);
pSc= Rnd(0.1*p0);

Finish= 0; % no legends --> make Finish 1 to plot legends
Finish= P.t(end)>=Par.General.tEnd; % legends in last display
t= P.t-P.t(1);

OFFSET= -20;

%==== Hemodynamics
figure(1);
subplot(2,4,[3,4,7,8]); plot(t,[...
    P.TubeLArt.pIn/pSc,...
    OFFSET+P.TubeRArt.pIn/pSc,...
    P.Lv.pIn/pSc,...
    OFFSET+P.Rv.pIn/pSc,...
    P.Lv.V/VSc,...
    OFFSET+(P.Rv.V)/VSc,...
    P.La.V/VSc,...
    OFFSET+P.Ra.V/VSc,...
    P.ValveLArt.q/qSc,...
    OFFSET+P.ValveRArt.q/qSc,...
    P.ValveLAv.q/qSc,...
    OFFSET+P.ValveRAv.q/qSc,...
    P.ValveLVen.q/qSc,...
    OFFSET+P.ValveRVen.q/qSc,...
    P.ValveDUCT.q/qSc,...
    P.ValveVSD.q/qSc,...
    P.ValveASD.q/qSc]);

if Finish
    legend('pLArt','pRArt','pLv','pRv','VLv','VRv','VLa','VRa','qLArt','qRArt',...
        'qLAv','qRAv','qLVen','qRVen','qDUCT','qVSD','qASD',2);
end
title(['FLOW[',num2str(qSc),']; PRESSURE[',num2str(pSc),']; VOLUME[',...
    num2str(VSc),']']);
xlabel('time [s]');

Calp= 0.001; CalV= 1e6;
% p-V loops
subplot(2,4,1); plot(...
    CalV*P.La.V,10*Calp*P.La.pIn,...
    CalV*P.Ra.V,10*Calp*P.Ra.pIn,...
    CalV*P.Lv.V,Calp*P.Lv.pIn,...
    CalV*P.Rv.V,Calp*P.Rv.pIn);
if Finish
    legend('La px10','Ra px10','Lv','Rv',2);
end
ylabel('pressure [kPa]');
xlabel('volume [ml]');

%Sf-Ef loops
X1=P.La.Sarc.Ef; Y1=Calp*P.La.Sarc.Sf;
X2=P.Ra.Sarc.Ef; Y2=Calp*P.Ra.Sarc.Sf;
X3=P.Rv.Sarc.Ef; Y3=Calp*P.Rv.Sarc.Sf;
X4=P.Sv.Sarc.Ef; Y4=Calp*P.Sv.Sarc.Sf;
if isfield(Par.Lv.Sarc,'Am')
    X5=P.Lv.Sarc.Sarc.Ef(:,1); Y5=Calp*P.Lv.Sarc.Sarc.Sf(:,1);
    X6=P.Lv.Sarc.Sarc.Ef(:,2); Y6=Calp*P.Lv.Sarc.Sarc.Sf(:,2);
    X7=P.Lv.Sarc.Sarc.Ef(:,3); Y7=Calp*P.Lv.Sarc.Sarc.Sf(:,3);
    subplot(2,4,2); plot(...
        X1, Y1, X2, Y2, X6, Y6, X3, Y3, X4, Y4, X5, Y5, X7, Y7);
else
    X5=P.Lv.Sarc.Ef; Y5=Calp*P.Lv.Sarc.Sf;
    subplot(2,4,2); plot(...
        X1, Y1, X2, Y2, X5, Y5, X3, Y3, X4, Y4);
end
if Finish
    legend('La','Ra','LW','RW','SW',2);
end
ylabel('myofiber stress [kPa]');
xlabel('myofiber strain [-]');

% clipped low venous, atrial and ventricular pressures
aux= 1.2*max(max([P.La.pIn,P.Ra.pIn]))/pSc;
subplot(2,4,5:6); plot(t,[...
    P.La.pIn/pSc,...
    P.Ra.pIn/pSc,...
    min(aux,P.Lv.pIn/pSc),...
    min(aux,P.Rv.pIn/pSc),...
    P.TubeLVen.pIn/pSc,...
    P.TubeRVen.pIn/pSc,...
    ]);
if Finish
    legend('pLa','pRa','pLv','pRv','pLVen','pRVen',2);
end
ylabel('pressure [kPa]');
xlabel('time [s]');

figure(1); pause(0.1);

return

%========== AUXILARY FUNCTIONS =============

function X=Rnd(x);
X1= 10^round(log(x)/log(10));
X2=  2^round(log(x/X1)/log(2));
X=X1*X2;
return

