function SVarDot= CircSVarDot(tDummy,SVar,flag);
%function SVarDot= CircSVarDot(tDummy,SVar,flag);
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% Differential equation in the format to be eaten by odeXX-function
%INPUT
% tDummy  = a dummy variable, irrelevant (needed by odeXX, representing time)
% SVar= column vector of State variables,
% !!! if SVar is a matrix, column direction -> time
% flag    = irrelevant, needed for odeXX
% global Par = Par-structure, containing all relevant information
%OUTPUT
% SVarDot= column vector (or matrix) of derivatives of State Variables

global Par

% Par    = structure containing dependent variables
Par.SVar= SVar'; % convert column vector SVar to row vector Par.SVar
SVar2Par; %script to convert Par.SVar to physiologic values in Par
% script text has been generated by CircNew function

%read out of general parameters
t     = Par.t;
p0    = Par.General.p0;
q0    = Par.General.q0;

%=X=X= Cavity pressures and cross-sections
Par.La        = CavityMech(Par.La)         ; % sarcomere length and pressures
Par.Ra        = CavityMech(Par.Ra)         ; %
[Par.Lv, Par.Sv, Par.Rv]= TwinBubble(Par.Lv, Par.Sv, Par.Rv);%Coupled Rv-Lv
% [Par.Lv, Par.Sv, Par.Rv]= TwinBubbleBu(Par.Lv, Par.Sv, Par.Rv);%Coupled Rv-Lv

% Pericardium around 4 cavities
Par.Peri.V    = Par.Lv.V+Par.Rv.V+Par.Lv.VWall+Par.Sv.VWall+Par.Rv.VWall...
    +Par.La.V+Par.La.VWall+Par.Ra.V+Par.Ra.VWall;
Par.Peri = SackMech(Par.Peri);
pPeri    = Par.Peri.p;
Par.La.p = Par.La.p + 0.5*pPeri; % human pericardium half around La
Par.Lv.p = Par.Lv.p + pPeri; 
Par.Ra.p = Par.Ra.p + pPeri;
Par.Rv.p = Par.Rv.p + pPeri;
%-----

%=X=X= Tube pressures, wave impedances and cross-sections
Par.TubeLArt  = TubeDynamics(Par.TubeLArt); % Aorta
Par.TubeLVen  = TubeDynamics(Par.TubeLVen); % Pulmonary Venes
Par.TubeRArt  = TubeDynamics(Par.TubeRArt); % Pulmonary Artery
Par.TubeRVen  = TubeDynamics(Par.TubeRVen); % Systemic Venes

%=X=X= Systemic peripheral resistance
Par.LRp.R= (p0-Par.TubeRVen.p)/q0; %blood pressure control by opening circulation at RVen
Par.LRp.q= (Par.TubeLArt.p-Par.TubeRVen.p)./Par.LRp.R; %closed system, systemic flow
Par.TubeLArt.VDot= Par.TubeLArt.VDot-Par.LRp.q; % outflow of arterial compartment
%Par.TubeRVen.VDot= Par.TubeRVen.VDot+Par.LRp.q; % closed circulation
Par.TubeRVen.VDot= Par.TubeRVen.VDot+q0; % inflow in open circulation

%--- non-linear pressure-flow relation of pulmonary circulation
pNorm    = (Par.TubeRArt.p-Par.TubeLVen.p)/Par.General.pDropPulm;
Par.RRp.q= sign(pNorm).*abs(pNorm).^2.0 * q0; %power^2 flow increase with pressure drop
Par.TubeRArt.VDot  = Par.TubeRArt.VDot-Par.RRp.q;
Par.TubeLVen.VDot  = Par.TubeLVen.VDot+Par.RRp.q;

%=X=X= FLOWS AROUND VALVES
% Flow continuity
% Time derivatives of volumes and boundary pressures pIn and pOut
% Time derivatives of flows

% Enlarged leak of atrioventricular valves during diastole
dL= Par.Lv.T ./ Par.Lv.Am *(5e-4*Par.Lv.AmRef^2/Par.Lv.VWall); % estimate mitral leak signal
PassiveLv= 1-tanh(dL.^2); % If passive, mitral valve leaks
Par.ValveLAv.ALeak= max(0.2*PassiveLv,1e-6) * Par.ValveLAv.AOpen;
% Mitral regurgitation
dR= Par.Rv.T ./ Par.Rv.Am *(5e-4*Par.Rv.AmRef^2/Par.Rv.VWall); % estimate tricuspid leak signal
PassiveRv= 1-tanh(dR.^2); % If passive, tricuspid valve leaks
Par.ValveRAv.ALeak= max(0.2*PassiveRv,1e-6) * Par.ValveRAv.AOpen;

%venous outflow areas in atria vary with venous diameter
Par.ValveLVen.AOpen= Par.TubeLVen.A;
Par.ValveRVen.AOpen= Par.TubeRVen.A;

ValveStr={'ValveLVen','ValveLAv','ValveLArt','ValveRVen','ValveRAv',...
    'ValveRArt','ValveDUCT','ValveVSD','ValveASD'};
VDot(ValveStr); % VolumeDot of compliances = sum(flows)
% Par.ValveRAv.ALeak=0.00005;
qDot(ValveStr); % FlowDot in Valve = fu(PressureDifference over Valve)

% time Par.t is a state variable
Par.tDot= 1;
Par.SVarDot= zeros(size(Par.SVar));
Par2SVarDot; % script, generated by CircNew, to fill Par.SVarDot
SVarDot= real(Par.SVarDot)'; % odeXX requires SVarDot to be a row vector

return

% ========= Auxilary functions ==============================

%==== VALVE RELATED FUNCTIONS

function VDot(ValveStr);
% Volume derivatives in neighboring chambers/tubes
global Par
nValve= size(ValveStr,2);
for iValve=1:nValve;
    Valve = ValveStr{iValve}; % string: name of valve 
    Prox  = Par.(Valve).Prox; % string: name of proximal chamber
    Dist  = Par.(Valve).Dist; % string: name of distal chamber
    q     = Par.(Valve).q;
    Par.(Prox).VDot  = Par.(Prox).VDot  -q;
    Par.(Prox).qRemod= Par.(Prox).qRemod-q;
    Par.(Prox).pIn   = Par.(Prox).p+Par.(Prox).VDot.*Par.(Prox).Z;
    Par.(Dist).VDot  = Par.(Dist).VDot  +q;
    Par.(Dist).qRemod= Par.(Dist).qRemod+q;
    Par.(Dist).pIn   = Par.(Dist).p+Par.(Dist).VDot.*Par.(Dist).Z;
end
return

function qDot(ValveStr);
%flow derivative from pressure drop, using Bernouilli and inertia
global Par
nValve= size(ValveStr,2);
for iValve=1:nValve;
    Valve = ValveStr{iValve}; % string: name of valve 
    Prox  = Par.(Valve).Prox; % string: name of proximal chamber
    Dist  = Par.(Valve).Dist; % string: name of distal chamber
    q     = Par.(Valve).q;
    AOpen = Par.(Valve).AOpen;
    ALeak = Par.(Valve).ALeak;
    Len   = Par.(Valve).Len;
    rhob  = 1050;
    Dp    = Par.(Prox).pIn-Par.(Dist).pIn; %pressure drop

    % numerical safety for valve opening around flow= 0
    pMargin= 10; %pressure threshold for valve closure in Nm-2
    vMargin= 0.01*sqrt(abs(2*pMargin)/rhob); %velocity threshold for valve opening
    PF = double(Dp>-pMargin)    ; PB= double(Dp<+pMargin);
    QF = double(q>AOpen*vMargin); QB= double(q<-ALeak*vMargin);
    AFw= ( QF| PF).*AOpen; %forward flow channel area
    ABw= ( QB| PB).*ALeak; %backward flow channel area
    A= max(AFw,ABw); %opening area

    AProx= Par.(Prox).A; ADist= Par.(Dist).A;% proximal and distal orifice areas
    v1= q./AProx; v2= q./A; v3= q./ADist;
    % narrow outflow area widens with forward flow
    DpB= (0.5*rhob) * ( QF.*max(v2.^2-v1.^2,0) - QB.*max(v2.^2-v3.^2,0));
    %                       Bernouilli pressure drop

    L= rhob*( Len./A+ 0.5*(1./sqrt(AProx)+1./sqrt(ADist)));
    %proximal and distal series inertial effects added to valve inertia
    Par.(Valve).L= L;
    Par.(Valve).qDot= (Dp-DpB)./L; %flow derivative
end
return
