function [Sheet,Error]= SheetAdapt(Sheet,AdaptType);
% function Sheet= SheetAdapt(Sheet,AdaptType);
% Simulates adaptation of sheet geometry to load
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

AdaptWallArea=0; AdaptWallVolume=0; AdaptSarcLength=0;
for i=1:length(AdaptType);
    if strcmp(AdaptType{i},'WallArea'  ); AdaptWallArea  =1; end
    if strcmp(AdaptType{i},'WallVolume'); AdaptWallVolume=1; end
    if strcmp(AdaptType{i},'SarcLength'); AdaptSarcLength=1; end
end


Sarc= Sheet.Sarc;
Am= mean(Sheet.Am); Cm= mean(Sheet.Cm); VWall= Sheet.VWall;
z= 1.5*VWall*(Cm./Am); z2=min(0.9,z^2);
AdaptSfPasMax= Sarc.Adapt.SfPasMax/(1-z2);

Ls     = Sarc.Ls ;
Lsi    = Sarc.Lsi;
LsMax  = max(Lsi);
LsMin  = min(Lsi);
Power  = max(0,-(Sarc.Sf-Sarc.SfPasT).*Sarc.LsiDot);
LsAct  = mean(Power.*Lsi)/mean(Power);

% FacXXX= Ratio (Target value)/(Actual value)
FacStrain= (Sarc.Adapt.LsBe*LsMin)/(Sarc.Adapt.LsEe*LsMax);
        T= Sarc.Adapt.SfPasMax; % max passive stress
FacSfPas = T/sqrt(max(Sarc.SfPasT)^2+0.01*T^2); FacSfPas=FacSfPas^0.3;
FacLsAct = (Sarc.Adapt.LsEe+0.7*(Sarc.Adapt.LsBe-Sarc.Adapt.LsEe))/LsAct;

% Clipping of Fac around 1 with range +/-a 
ClipFac= @(x,a) exp(a*tanh(log(x)/a));
FacStrain= ClipFac(FacStrain,0.5);
FacSfPas = ClipFac(FacSfPas ,0.5);
FacLsAct = ClipFac(FacLsAct ,0.5);

% Adaptation factors
FacVWall= FacLsAct^(0.2) * FacSfPas^(-0.6);
FacLs   = FacLsAct^(0.5*Sarc.dLsPas/Sarc.LsRef);
FacAm   = FacStrain^(-1.0) * FacSfPas^(-0.1);
% FacAm   = (0.1 + 0.6*FacStrain + 0.3*FacSfPas)^(-1.0);

%=== Carrying out adaptation

Error=[];

%hypertrophy by stretch of passive matrix, preservation of fiber length
if AdaptWallVolume
    Vw0= Sheet.VWall;
    Vw1= Vw0 * FacVWall;
    Sheet.VWall=Vw1;
    Error= [Error,abs(log(FacVWall))];
end

if AdaptSarcLength
    %Shifting active sarcomere range over passive matrix
    Sarc.LsRef= FacLs*Sarc.LsRef;
    Sarc.Lsi  = FacLs*Sarc.Lsi  ;
    Error= [Error, abs(log(FacLs))];
end

if AdaptWallArea
    %Strain softening of passive matrix by creep
    Sheet.AmRef= Sheet.AmRef*FacAm;
    Error= [Error,abs(log(FacAm))];
end

% Brings LsRef back to 2 um, using interdependence of AmRef and LsRef
Fac=2/Sarc.LsRef;
a=0.1;
Sarc.LsRef=Sarc.LsRef*Fac^a;
Sarc.SfPas=Sarc.SfPas*Fac^(a*Sarc.Ls0Pas/Sarc.dLsPas);
Sheet.AmRef=Sheet.AmRef*Fac^(2*a);
%-------

Error=mean(Error);
disp(['FacSfPas|Strain|LsAct|Error*1e3: ',...
    num2str(round(1000*[log([1,FacSfPas,FacStrain,FacLsAct]),Error]),'% 5d')]);

%---

Sheet.Sarc= Sarc;
% disp([FacSfPas,FacStrain,FacLsAct])
return
