function Sheet= SheetMech(Sheet);
% function Sheet= SheetMech(Sheet);
% mechanics of a patch of curved thick-walled muscular wall
% Structure Sheet.
%      AmRef: 0.0143         = area with Ls=Sarc.LsRef
%      VWall: 1.4762e-004    = wall volume
%         Am: [852x1 double] = currend patch area
%         Cm: [852x1 double] = curvature=1/radius
%       Sarc: [1x1 struct]   Changed
%          T: [852x1 double] Changed : wall tension (N/m)
%     pTrans: [852x1 double] Changed : transmuaral pressure
%      DTDAm: [852x1 double] Changed : wall stiffness
% matrix proof
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

% Input

global Par

if isfield(Sheet.Sarc,'Am')
    Sheet= MultiPatch(Sheet);
else
    VWall= sparse(diag(Sheet.VWall)); %wall volume
    Am   = Sheet.Am   ; %midwall area of myo-wall
    Cm   = Sheet.Cm   ; %curvature=1/r midwall

    % dimensionless z for wall thickness to cavity radius
    z   = 1.5*(Cm./Am)*VWall; z2=z.^2; z4=z2.^2;
    % for thick-walled sphere: z=VWall/2Vm

    % TDSf= 0.5*VWall*(1+z2/3+z4/5+....)./Am;
    TDSf= 0.5*(1+0.27*z2)*VWall./Am; % best work balance TdA/SfdEf
    % Polynomial approximate of ratio wall tension/fiber stress.

    % Sheet fiber strain
    Sarc= Sheet.Sarc;
    Sarc.Ef= 0.5*log(Sheet.Am/sparse(diag(Sheet.AmRef))) -z2/12 -0.019*z4;
    Sarc=SarcMech(Sarc); %all sheets have only sarcomere fibers
    Sf     = Sarc.Sf; % stress

    % Output variables of SarcMech
    T      =  TDSf .* Sf; % wall tension
    pTrans = 2 * T .* Cm; % transmural pressure
    DTDAm  = 0.5 * TDSf .* Sarc.DSfDEf ./ Am; % sheet stiffness

    Sheet.Sarc   = Sarc;
    Sheet.T      = T;
    Sheet.pTrans = pTrans;
    Sheet.DTDAm  = DTDAm;
end

return

