function SplitSheet(SheetName,nPatch)
% function SplitSheet(SheetName,nPatch)
% Splits Sheet in nPatch equally sized Subsheets
% if nPatch<=1, inverse action:
%   then  sheets merge into single average sheet
% Because of getting new state variables,
% >> Par=WriteSVarFiles(Par)
% is executed
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

global Par

Sheet=getfield(Par,{1},SheetName);% get sheet from Par structure

FldSarc= {'ActivationDelay','Ef','LsRef','Ls0Pas','dLsPas','SfPas',...
    'Lsi0Act','LenSeriesElement','SfAct','vMax','TimeAct','TR',...
    'TD','C','CDot','CRest','Lsi','LsiDot'};
if nPatch>0; % split one Sheet in n Patches
    %Parent properties

    Sarc= [];
    Sarc.VWall= repmat( Sheet.VWall/nPatch,[1,nPatch]);
    Sarc.AmRef= repmat( Sheet.AmRef/nPatch,[1,nPatch]);
    Sarc.Am   = repmat( Sheet.Am   /nPatch,[1,nPatch]);
    Sarc.Cm   = repmat( Sheet.Cm          ,[1,nPatch]);
    for iField=1:length(FldSarc)
        Sarc.Sarc.(FldSarc{iField}) = ...
            repmat(Sheet.Sarc.(FldSarc{iField}),[1,nPatch]);
    end
    fn= fieldnames(Sheet.Sarc.Adapt);
    for iField=1:length(fn)
        Sarc.Sarc.Adapt.(fn{iField}) = ...
            repmat(Sheet.Sarc.Adapt.(fn{iField}),[1,nPatch]);
    end
    Sheet.Sarc= Sarc;
    
else % replace group of sub-sheets by single average
    Sarc=Sheet.Sarc; SarcSarc=Sarc.Sarc; SarcSarcAdapt=SarcSarc.Adapt;
    Sheet.Sarc = [];
    Sheet.VWall= sum(Sarc.VWall,2);
    Sheet.AmRef= sum(Sarc.AmRef,2);
    Sheet.Cm   = (Sarc.Cm*Sarc.VWall') ./ sum(Sarc.VWall,2);
    Sheet.Am   = sum(Sarc.Am,2);
    for iField=1:length(FldSarc)
        Sheet.Sarc.(FldSarc{iField}) = sum(SarcSarc.(FldSarc{iField})...
            * sparse(diag(Sarc.VWall)),2)/Sheet.VWall;
    end
    fn= fieldnames(SarcSarcAdapt);
    for iField=1:length(fn)
        Sheet.Sarc.Adapt.(fn{iField}) = ...
            sum(SarcSarc.Adapt.(fn{iField})...
            * sparse(diag(Sarc.VWall)),2)/Sheet.VWall;
    end

end

Par=setfield(Par,{1},SheetName,Sheet);

% Initialization of Par.SVar and Par.SVarDot
Par=WriteSVarFiles(Par);
Par.SVar=[];
save Par Par; % Save file and SVar Files for new number of state variables
clear
return

