function AdaptE(a,b);
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% Adapts under exercise conditions:
% a times resting flow q0
% b times resting cycle length tCycle
global Par

% Reach hemodynamic steady state
Par.General.q0=a*Par.General.q0;
Par.General.tCycle=b*Par.General.tCycle;
Par.General.DtSimulation=25;
Par.t(end)=0;
Par.Specific.MenuNr=1;
CircAdapt;

% Adapt Exercise
Par.General.DtSimulation=1000;
Par.t(end)=0;
Par.Specific.MenuNr=3;
CircAdapt;

% Reach hemodynamic steady state
Par.General.DtSimulation=5;
Par.t(end)=0;
Par.Specific.MenuNr=1;
CircAdapt;

% Adapt Exercise
Par.General.DtSimulation=1000;
Par.t(end)=0;
Par.Specific.MenuNr=3;
CircAdapt;

% Return to resting conditions
Par.General.q0=Par.General.qRest;
Par.General.tCycle=Par.General.tCycleRest;
Par.General.DtSimulation=25;
Par.t(end)=0;
Par.Specific.MenuNr=1;
CircAdapt;

% Final cycle
Par.General.DtSimulation=.1;
Par.t(end)=0;
Par.Specific.MenuNr=1;
CircAdapt;
return

