function [WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(Par);
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function calculates ventricular pump work and myofiber work density
% in the ventricular walls per beat

WPumpL=work(Par.Lv.p,Par.Lv.V); % LV pump work
WPumpR=work(Par.Rv.p,Par.Rv.V); % RV pump work
WPump=WPumpL+WPumpR; % Total ventricular pump work

WSarcL=work(Par.Lv.Sarc.Sf,Par.Lv.Sarc.Ef)*Par.Lv.VWall; % LV free wall myofiber work
WSarcS=work(Par.Sv.Sarc.Sf,Par.Sv.Sarc.Ef)*Par.Sv.VWall; % Septal wall myofiber work
WSarcR=work(Par.Rv.Sarc.Sf,Par.Rv.Sarc.Ef)*Par.Rv.VWall; % RV free wall myofiber work
WSarc=WSarcL+WSarcS+WSarcR;

WDenSarcL=WSarcL/Par.Lv.VWall; % LV free wall myofiber work density
WDenSarcS=WSarcS/Par.Sv.VWall; % Septal wall myofiber work density
WDenSarcR=WSarcR/Par.Rv.VWall; % RV free wall myofiber work density
return


function W=work(p,V); %integrates pdV over whole vector
W=conv2(p,[0.5;0.5],'valid')' * conv2(V,[-1;1],'valid');
return

function P=power(p,V); %integrates pdV over whole vector
P=conv2(p,[0.5;0.5],'valid') .* conv2(V,[-1;1],'valid');
return
