% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 10 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;
load Par3000_Ad.mat % PHCh1 simulation
save Par Par
P1=Par;
load Par4500_Ad.mat % PHCh2 simulation
save Par Par
P2=Par;
load Par6000_Ad.mat % PHCh3 simulation
save Par Par
P3=Par;

i=260; % end of LV ejection in all simulations (aortic valve closure)

% Plot data points for NORM and PHCh simulations
CRatioAd=[PR.Sv.Cm(i)/PR.Lv.Cm(i);...
    P1.Sv.Cm(i)/P1.Lv.Cm(i);...
    P2.Sv.Cm(i)/P2.Lv.Cm(i);...
    P3.Sv.Cm(i)/P3.Lv.Cm(i)];
PRatioAd=[(max(PR.Lv.pIn)-max(PR.Rv.pIn))/max(PR.Lv.pIn);...
    (max(P1.Lv.pIn)-max(P1.Rv.pIn))/max(P1.Lv.pIn);...
    (max(P2.Lv.pIn)-max(P2.Rv.pIn))/max(P2.Lv.pIn);...
    (max(P3.Lv.pIn)-max(P3.Rv.pIn))/max(P3.Lv.pIn)];
figure; plot(PRatioAd,-CRatioAd,'.r'); hold on
ylabel('CRatio');
xlabel('PRatio');
hold on

% Load PHAc simulations
load Par3000_Ac.mat % PHAc1 simulation
save Par Par
P1=Par;
load Par4500_Ac.mat % PHAc2 simulation
save Par Par
P2=Par;
load Par6000_Ac.mat % PHAc3 simulation
save Par Par
P3=Par;

% Plot data points for PHAc simulations
CRatioAc=[PR.Sv.Cm(i)/PR.Lv.Cm(i);...
    P1.Sv.Cm(i)/P1.Lv.Cm(i);...
    P2.Sv.Cm(i)/P2.Lv.Cm(i);...
    P3.Sv.Cm(i)/P3.Lv.Cm(i)];
PRatioAc=[(max(PR.Lv.pIn)-max(PR.Rv.pIn))/max(PR.Lv.pIn);...
    (max(P1.Lv.pIn)-max(P1.Rv.pIn))/max(P1.Lv.pIn);...
    (max(P2.Lv.pIn)-max(P2.Rv.pIn))/max(P2.Lv.pIn);...
    (max(P3.Lv.pIn)-max(P3.Rv.pIn))/max(P3.Lv.pIn)];
plot(PRatioAc(2:4),-CRatioAc(2:4),'.b'); hold on

% Linear Regression (NORM and PHCh datapoints)
LinFit = polyfit(PRatioAd,-CRatioAd,1);
CR_Sim= LinFit(2) + LinFit(1)*[0:.1:1];
PR_Sim= [0:.1:1];
plot(PR_Sim,CR_Sim,'k');

% Linear Regression (Dellegrottaglie)
CR_Del= 0.0052 + 1.0314*[0:.1:1];
PR_Del= [0:.1:1];
plot(PR_Del,CR_Del,'r');

axis equal
axis([0 1 0 1]);