% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 4 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;

t=PR.t-min(PR.t);

VSc= 1e-6; pSc= 1e3; 

figure;
% LV and aortic pressures
subplot(7,1,[1,2]), plot(t,[PR.Lv.pIn/pSc PR.TubeLArt.pIn/pSc])
ylim([0 17])
xlim([0 0.85])
ylabel('pressure [kPa]');

% flows through mitral and aortic valves
subplot(7,1,3), plot(t,[PR.ValveLAv.q PR.ValveLArt.q]/VSc)
ylim([-50 500])
xlim([0 0.85])
ylabel('flow [ml/s]');

% RV and pulmonary artery pressures
subplot(7,1,[4,5]), plot(t,[PR.Rv.pIn/pSc PR.TubeRArt.pIn/pSc])
ylim([0 4])
xlim([0 0.85])
ylabel('pressure [kPa]');

% flows through tricuspid and pulmonary valves
subplot(7,1,6), plot(t,[PR.ValveRAv.q PR.ValveRArt.q]/VSc)
ylim([-50 500])
xlim([0 0.85])
ylabel('flow [ml/s]');

% LV and RV cavity volumes
subplot(7,1,7), plot(t,[PR.Lv.V PR.Rv.V]/VSc)
ylim([0 200])
xlim([0 0.85])
ylabel('volume [ml]');
xlabel('time [s]');

