% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 6 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;
load Par3000_Ad.mat % PHCh1 simulation
save Par Par
P1=Par;
load Par4500_Ad.mat % PHCh2 simulation
save Par Par
P2=Par;
load Par6000_Ad.mat % PHCh3 simulation
save Par Par
P3=Par;

t=PR.t-min(PR.t);

VSc= 1e-6; pSc= 1e3; CSc= 1e2;
figure;
% LV pressure-volume loop
subplot(12,6,[1,2,3,7,8,9,13,14,15,19,20,21]); plot(...
    PR.Lv.V/VSc,PR.Lv.pIn/pSc,...
    P1.Lv.V/VSc,P1.Lv.pIn/pSc,...
    P2.Lv.V/VSc,P2.Lv.pIn/pSc,...
    P3.Lv.V/VSc,P3.Lv.pIn/pSc);
ylabel('pressure [kPa]');
xlabel('volume [ml]');
title('LV')
axis([50 160 0 17]);
% RV pressure-volume loop
subplot(12,6,[4,5,6,10,11,12,16,17,18,22,23,24]); plot(...
    PR.Rv.V/VSc,PR.Rv.pIn/pSc,...
    P1.Rv.V/VSc,P1.Rv.pIn/pSc,...
    P2.Rv.V/VSc,P2.Rv.pIn/pSc,...
    P3.Rv.V/VSc,P3.Rv.pIn/pSc);
xlabel('volume [ml]');
title('RV')
axis([50 160 0 17]);
legend('NORM','PHCh1','PHCh2','PHCh3')
% Myofiber stress-strain loop LV free wall
subplot(12,6,[25,26,31,32,37,38,43,44]); plot(...
    PR.Lv.Sarc.Ef,PR.Lv.Sarc.Sf/pSc,...
    P1.Lv.Sarc.Ef,P1.Lv.Sarc.Sf/pSc,...
    P2.Lv.Sarc.Ef,P2.Lv.Sarc.Sf/pSc,...
    P3.Lv.Sarc.Ef,P3.Lv.Sarc.Sf/pSc);
ylabel('myofiber stress [kPa]');
xlabel('myofiber strain [-]');
title('LW')
axis([-0.2 0.1 0 70]);
% Myofiber stress-strain loop Septal wall
subplot(12,6,[27,28,33,34,39,40,45,46]); plot(...
    PR.Sv.Sarc.Ef,PR.Sv.Sarc.Sf/pSc,...
    P1.Sv.Sarc.Ef,P1.Sv.Sarc.Sf/pSc,...
    P2.Sv.Sarc.Ef,P2.Sv.Sarc.Sf/pSc,...
    P3.Sv.Sarc.Ef,P3.Sv.Sarc.Sf/pSc);
xlabel('myofiber strain [-]');
title('SW')
axis([-0.2 0.1 0 70]);
% Myofiber stress-strain loop RV free wall
subplot(12,6,[29,30,35,36,41,42,47,48]); plot(...
    PR.Rv.Sarc.Ef,PR.Rv.Sarc.Sf/pSc,...
    P1.Rv.Sarc.Ef,P1.Rv.Sarc.Sf/pSc,...
    P2.Rv.Sarc.Ef,P2.Rv.Sarc.Sf/pSc,...
    P3.Rv.Sarc.Ef,P3.Rv.Sarc.Sf/pSc);
xlabel('myofiber strain [-]');
title('RW')
axis([-0.2 0.1 0 70]);
% LV free wall curvature
subplot(12,6,[49,50,55,56,61,62,67,68]); plot(...
    t,-PR.Lv.Cm/CSc,...
    t,-P1.Lv.Cm/CSc,...
    t,-P2.Lv.Cm/CSc,...
    t,-P3.Lv.Cm/CSc);
ylabel('midwall curvature [cm^-1]');
xlabel('time [s]');
title('LW')
axis([0 0.85 -0.05 0.35]);
% Septal wall curvature
subplot(12,6,[51,52,57,58,63,64,69,70]); plot(...
    t,PR.Sv.Cm/CSc,...
    t,P1.Sv.Cm/CSc,...
    t,P2.Sv.Cm/CSc,...
    t,P3.Sv.Cm/CSc);
xlabel('time [s]');
title('SW')
axis([0 0.85 -0.05 0.35]);
% RV free wall curvature
subplot(12,6,[53,54,59,60,65,66,71,72]); plot(...
    t,PR.Rv.Cm/CSc,...
    t,P1.Rv.Cm/CSc,...
    t,P2.Rv.Cm/CSc,...
    t,P3.Rv.Cm/CSc);
xlabel('time [s]');
title('RW')
axis([0 0.85 -0.05 0.35]);
