% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 7 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;
load Par3000_Ad.mat % PHCh1 simulation
save Par Par
P1=Par;
load Par4500_Ad.mat % PHCh2 simulation
save Par Par
P2=Par;
load Par6000_Ad.mat % PHCh3 simulation
save Par Par
P3=Par;

t=PR.t-min(PR.t);

figure;
% Pulmonary valve flow velocity
subplot(4,1,1), plot(...
    t,(PR.ValveRArt.q./PR.ValveRArt.AOpen),...
    t,(P1.ValveRArt.q./P1.ValveRArt.AOpen),...
    t,(P2.ValveRArt.q./P2.ValveRArt.AOpen),...
    t,(P3.ValveRArt.q./P3.ValveRArt.AOpen));
axis([0 0.85 -0.1 1]);
ylabel('flow velocity [m/s]');
title('Pulmonary valve')
legend('NORM','PHCh1','PHCh2','PHCh3')
% Tricuspid valve flow velocity
subplot(4,1,2), plot(...
    t,(PR.ValveRAv.q./PR.ValveRAv.AOpen),...
    t,(P1.ValveRAv.q./P1.ValveRAv.AOpen),...
    t,(P2.ValveRAv.q./P2.ValveRAv.AOpen),...
    t,(P3.ValveRAv.q./P3.ValveRAv.AOpen));
axis([0 0.85 -0.05 0.5]);
ylabel('flow velocity [m/s]');
title('Tricuspid valve')
% Aortic valve flow velocity
subplot(4,1,3), plot(...
    t,(PR.ValveLArt.q./PR.ValveLArt.AOpen),...
    t,(P1.ValveLArt.q./P1.ValveLArt.AOpen),...
    t,(P2.ValveLArt.q./P2.ValveLArt.AOpen),...
    t,(P3.ValveLArt.q./P3.ValveLArt.AOpen));
axis([0 0.85 -0.1 1]);
ylabel('flow velocity [m/s]');
title('Aortic valve')
% Mitral valve flow velocity
subplot(4,1,4), plot(...
    t,(PR.ValveLAv.q./PR.ValveLAv.AOpen),...
    t,(P1.ValveLAv.q./P1.ValveLAv.AOpen),...
    t,(P2.ValveLAv.q./P2.ValveLAv.AOpen),...
    t,(P3.ValveLAv.q./P3.ValveLAv.AOpen));
axis([0 0.85 -0.05 0.5]);
ylabel('flow velocity [m/s]');
title('Mitral valve')