% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 8 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;
load Par3000_Ad.mat % PHCh1 simulation
save Par Par
P1=Par;
load Par4500_Ad.mat % PHCh2 simulation
save Par Par
P2=Par;
load Par6000_Ad.mat % PHCh3 simulation
save Par Par
P3=Par;

% Timingdata derived from NORM and PHCh simulations

% moment of mitral valve (ValveLAv) opening [P1 P2 P3 P4]
Opmi=[321.5; 321.5; 320; 320.5]*2;
% moment of mitral valve (ValveLAv) closure [P1 P2 P3 P4]
Clmi=[102.5; 101.5; 101; 101.5]*2;
% moment of aortic valve (ValveLArt) opening [P1 P2 P3 P4]
Opao=[144.5; 144.5; 144.5; 146]*2;
% moment of aortic valve (ValveLArt) closure [P1 P2 P3 P4]
Clao=[259; 259; 259; 260]*2;
% moment of tricuspid valve (ValveRAv) opening [P1 P2 P3 P4]
Optr=[305; 312.5; 313; 313.5]*2;
% moment of tricuspid valve (ValveRAv) closure [P1 P2 P3 P4]
Cltr=[117; 106; 95.5; 89]*2;
% moment of pulmonary valve (ValveRArt) opening [P1 P2 P3 P4]
Oppv=[134.5; 135; 135; 135]*2;
% moment of pulmonary valve (ValveRArt) closure [P1 P2 P3 P4]
Clpv=[270; 266; 263; 262]*2;
% moment of maximum pulmonary valve (ValveRArt) flow [P1 P2 P3 P4]
Maxpv=[189; 183; 178; 172]*2;

dtPeak_pv=Maxpv-Oppv; % right ventricular AT
dtEject_pv=Clpv-Oppv; % right ventricular ET
RatioPeakEject=dtPeak_pv./dtEject_pv; % AT/ET
dtIsoCon_rv=Oppv-Cltr; % right ventricular ICT
dtIsoRel_rv=Optr-Clpv; % right ventricular IRT
RatioIsoConEject=dtIsoCon_rv./dtEject_pv; % right ventricular ICT/ET
RatioIsoEject=((Optr-Cltr)-dtEject_pv)./dtEject_pv; % right ventricular (ICT+IRT)/ET

%%% Comparison of simulations with experimental measurements
%%% blue datapoints  = Simulated data
%%% green datapoints = Bossone et al. (Int.J.Card.Im., 2000)
%%% black datapoints = Tei et al. (Am.J.Card., 1998)

% RV flow acceleration and ejection times (AT and ET)
figure; hold on
plot([1;2;3;4],dtPeak_pv,'.')
plot([6,7],[170;80],'.g'), plot([6,7],[170+30;80+30],'+g')
plot([9;10;11;12],dtEject_pv,'.')
plot([14,15],[380;300],'.g'), plot([14,15],[380+60;300+90],'+g')
axis([0 16 0 500])
ylabel('time [ms]');
title('AT (left) and ET (right)')

figure; hold on
plot([1;2;3;4],RatioPeakEject,'.')
plot([6;7],[0.450;0.270],'.g'), plot([6;7],[0.450+0.050;0.270+0.110],'+g')
axis([0 8 0 0.5])
ylabel('time ratio [-]');
title('AT/ET')

% RV isovolumic contraction and isovolumic relaxation times (ICT and IRT)
figure; hold on
ylim([0 200])
plot([1;2;3;4],dtIsoCon_rv,'.')
plot([6;7],[38;80],'.k'), plot([6;7],[38+7;80+35],'+k')
plot([9;10;11;12],dtIsoRel_rv,'.')
plot([14;15],[49;131],'.k'), plot([14;15],[49+9;131+35],'+k')
axis([0 16 0 200])
ylabel('time [ms]');
title('ICT (left) and IRT (right)')

figure; hold on
plot([1;2;3;4],RatioIsoEject,'.')
plot([6;7],[0.28;0.89],'.k'), plot([6;7],[0.28+0.04;0.89+0.25],'+k')
axis([0 8 0 1.2])
ylabel('time ratio [-]');
title('(ICT+IRT)/ET')