% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function generates Figure 9 of TriSeg paper

% Load NORM and PHCh simulations
load Par1500_Ad.mat % NORM simulation
save Par Par
PR=Par;
load Par3000_Ad.mat % PHCh1 simulation
save Par Par
P1=Par;
load Par4500_Ad.mat % PHCh2 simulation
save Par Par
P2=Par;
load Par6000_Ad.mat % PHCh3 simulation
save Par Par
P3=Par;

t=PR.t-min(PR.t);

VSc= 1e-6; pSc= 1e3; CSc= 1e2;

figure;
subplot(2,1,1), plot(...
    t,(PR.Lv.pIn-PR.Rv.pIn)./(PR.Lv.pIn),...
    t,(P1.Lv.pIn-P1.Rv.pIn)./(P1.Lv.pIn),...
    t,(P2.Lv.pIn-P2.Rv.pIn)./(P2.Lv.pIn),...
    t,(P3.Lv.pIn-P3.Rv.pIn)./(P3.Lv.pIn));
axis([0 0.85 0 1]);
ylabel('SW/LW transmural pressure ratio [-]');

subplot(2,1,2), plot(...
    t,PR.Sv.Cm./abs(PR.Lv.Cm),...
    t,P1.Sv.Cm./abs(P1.Lv.Cm),...
    t,P2.Sv.Cm./abs(P2.Lv.Cm),...
    t,P3.Sv.Cm./abs(P3.Lv.Cm));
axis([0 0.85 0 1]);
ylabel('SW/LW midwall curvature ratio [-]');
xlabel('time [s]');

legend('NORM','PHCh1','PHCh2','PHCh3')

