% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% This function calculates data shown in Tables 2, 3, and 4 of TriSeg paper

%BEJ load Par1500_Ad; P1=Par; % NORM simulation
load ParSten; P1=Par; %
load Par; P2=Par;
load ParRef; P3=Par;
load ParStenoisis; P4=Par;
load ParSten; P5=Par; 
load ParSten; P6=Par; 
load ParSten; P7=Par; 

%BEJ load Par3000_Ac; P2=Par; % PHAc1 simulation
%load Par4500_Ac; P3=Par; % PHAc2 simulation
%load Par6000_Ac; P4=Par; % PHAc3 simulation
%load Par3000_Ad; P5=Par; % PHCh1 simulation
%load Par4500_Ad; P6=Par; % PHCh2 simulation
%load Par6000_Ad; P7=Par; % PHCh3 simulation

% Table 2: end-diastolic ventricular wall thicknesses in mm
%BEJ ED=[103;103;104;106;102;100;101]; % timepoints of mitral valve closure (=end-diastole)
ED=[1;1;1;1;1;1;1]; % timepoints of mitral valve closure (=end-diastole)
VWall=[P1.Lv.VWall P1.Sv.VWall P1.Rv.VWall; P2.Lv.VWall P2.Sv.VWall P2.Rv.VWall; P3.Lv.VWall P3.Sv.VWall P3.Rv.VWall; P4.Lv.VWall P4.Sv.VWall P4.Rv.VWall; P5.Lv.VWall P5.Sv.VWall P5.Rv.VWall; P6.Lv.VWall P6.Sv.VWall P6.Rv.VWall; P7.Lv.VWall P7.Sv.VWall P7.Rv.VWall]*1e6;
% LV free wall thickness
Thickness_ED_LW=(VWall(:,1)./([P1.Lv.Am(ED(1)); P2.Lv.Am(ED(2)); P3.Lv.Am(ED(3)); P4.Lv.Am(ED(4)); P5.Lv.Am(ED(5)); P6.Lv.Am(ED(6)); P7.Lv.Am(ED(7))]*1e4))*10
% Septal wall thickness
Thickness_ED_SW=(VWall(:,2)./([P1.Sv.Am(ED(1)); P2.Sv.Am(ED(2)); P3.Sv.Am(ED(3)); P4.Sv.Am(ED(4)); P5.Sv.Am(ED(5)); P6.Sv.Am(ED(6)); P7.Sv.Am(ED(7))]*1e4))*10
% RV free wall thickness
Thickness_ED_RW=(VWall(:,3)./([P1.Rv.Am(ED(1)); P2.Rv.Am(ED(2)); P3.Rv.Am(ED(3)); P4.Rv.Am(ED(4)); P5.Rv.Am(ED(5)); P6.Rv.Am(ED(6)); P7.Rv.Am(ED(7))]*1e4))*10

% Table 3: pressures, ventricular pump work, and tissue work densities
% Mean pulmonary artery pressures [kPa]
PAPmean=[mean(P1.TubeRArt.pIn); mean(P2.TubeRArt.pIn); mean(P3.TubeRArt.pIn); mean(P4.TubeRArt.pIn); mean(P5.TubeRArt.pIn); mean(P6.TubeRArt.pIn); mean(P7.TubeRArt.pIn)]./1000

% Ventricular pump stroke work (WPumpL,WPumpR) and 
% myofiber stroke work density (WDenSarcL,WDenSarcS,WDenSarcR)
[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P1);
Wstroke=[WPumpL, WPumpR];
Wstrokedensity=[WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P2);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P3);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P4);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P5);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P6);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR];

[WPumpL,WPumpR,WDenSarcL,WDenSarcS,WDenSarcR]=EnergyCheck(P7);
Wstroke=[Wstroke; WPumpL, WPumpR];
Wstrokedensity=[Wstrokedensity; WDenSarcL, WDenSarcS, WDenSarcR]/1000;

% LV pump stroke work [Pa*m^-3]
Wstroke_LV = Wstroke(:,1)
% RV pump stroke work [Pa*m^-3]
Wstroke_RV = Wstroke(:,2)
% LV free wall myofiber stroke work density [kPa]
Wstrokedensity_LW = Wstrokedensity(:,1)
% Septal wall myofiber stroke work density [kPa]
Wstrokedensity_SW = Wstrokedensity(:,2)
% RV free wall myofiber stroke work density [kPa]
Wstrokedensity_RW = Wstrokedensity(:,3)

% Table 4: midwall curvature ratio (CR) and transmural pressure ratio (PR)
i=260; % end of LV ejection in all simulations (aortic valve closure)
 
CR=-[P1.Sv.Cm(i)/P1.Lv.Cm(i);...
    P2.Sv.Cm(i)/P2.Lv.Cm(i);...
    P3.Sv.Cm(i)/P3.Lv.Cm(i);...
    P4.Sv.Cm(i)/P4.Lv.Cm(i);...
    P5.Sv.Cm(i)/P5.Lv.Cm(i);...
    P6.Sv.Cm(i)/P6.Lv.Cm(i);...
    P7.Sv.Cm(i)/P7.Lv.Cm(i)]
PR=[(max(P1.Lv.pIn)-max(P1.Rv.pIn))/max(P1.Lv.pIn);...
    (max(P2.Lv.pIn)-max(P2.Rv.pIn))/max(P2.Lv.pIn);...
    (max(P3.Lv.pIn)-max(P3.Rv.pIn))/max(P3.Lv.pIn);...
    (max(P4.Lv.pIn)-max(P4.Rv.pIn))/max(P4.Lv.pIn);...
    (max(P5.Lv.pIn)-max(P5.Rv.pIn))/max(P5.Lv.pIn);...
    (max(P6.Lv.pIn)-max(P6.Rv.pIn))/max(P6.Lv.pIn);...
    (max(P7.Lv.pIn)-max(P7.Rv.pIn))/max(P7.Lv.pIn)]
