function Tube= TubeAdapt(Tube,AdaptType);
% function Tube= TubeAdapt(Tube,AdaptType);
% AdaptType= {'Diameter', 'WallVolume'} indicates type of adaptation
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

AdaptDiameter=0; AdaptWallVolume=0;
for i=1:length(AdaptType);
    if strcmp(AdaptType{i},'Diameter')  ; AdaptDiameter  =1; end
    if strcmp(AdaptType{i},'WallVolume'); AdaptWallVolume=1; end
end

AuxDisplay  = [Tube.p0*1e-3,Tube.q0*1e3,Tube.pMax*1e-3,...
    Tube.A0*1e+4,Tube.AWall*1e+4];

%=== Sensor signal calculation
qRemod = Tube.qRemod;
qPos   = mean(max(0,qRemod)); qNeg=mean(max(0,-qRemod));
qMean  = abs(mean(qRemod));
qAux   = median([qPos;qNeg;qMean]); % determines size of entering blood vessel
vFlow  = qAux/mean(Tube.A);

pMax      = Tube.pIn + Tube.Z.*Tube.A*Tube.Adapt.vImpact;
WallStress= max(pMax.*(1+3*Tube.A/Tube.AWall));

Fac_vFlow    = Tube.Adapt.vFlowMean  / vFlow;
FacWallStress= Tube.Adapt.WallStress / WallStress;
Facp0        = Tube.p0   / sqrt( mean(Tube.p.^2) );
%---

%=== Carrying out adaptation
if AdaptDiameter;
    Tube.A0  = Tube.A0 / Fac_vFlow.^0.1;
    Tube.p0  = Facp0^0.3 * sqrt( mean(Tube.p.^2) );
end

if AdaptWallVolume
    Tube.AWall= Tube.AWall / FacWallStress^0.5;
    Tube.pMax = Tube.pMax*(max(pMax)/Tube.pMax)^0.25;
end
%---

disp('    p0(kPa), qRemod*(L/s), pMax(kPa), A0(cm2), AWall(cm2)');
disp([AuxDisplay;[Tube.p0*1e-3,Tube.q0*1e3,Tube.pMax*1e-3,...
    Tube.A0*1e+4,Tube.AWall*1e+4]]);
return
