function Tube= TubeDynamics(Tube);
%function Tube= TubeDynamics(Tube);
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
%Elastic Tube hemodynamics, related to the pressure/flow wave (e.g. aorta)
%
%INPUT/OUTPUT i/o
%Tube.
%          k: 8              i
%         p0: 12200          i
%        Len: 0.4001         i
%      AWall: 1.2866e-004    i
%         A0: 5.0000e-004    i
%          V: [852x1 double] i
%          A: [852x1 double] changed
%          p: [852x1 double] changed
%          Z: [852x1 double] changed
%        pIn: [852x1 double] changed
%       VDot: [852x1 double] changed
%     qRemod: [852x1 double] changed

rhob   = 1050;
AWalld3= Tube.AWall/3;
Tube.A = max(0.001*Tube.A0,Tube.V/Tube.Len); %mean cross-section of tube, safe for A0<0
Aux    = ((Tube.A+AWalld3)./(Tube.A0+AWalld3)).^(Tube.k/3-1);
p      = Tube.p0* ( Aux - 0.01*Tube.A0./Tube.A ); %safety for collapse
Tube.p = p;
Tube.Z = sqrt( rhob*(Tube.k-3) * max(1.0,p)/3) ./ (Tube.A+Tube.AWall/3);
% Avoids (too) high Z for low pressure

%=== Initializations for CircSVarDot
Tube.pIn   = p;
z0=zeros(size(p));
Tube.VDot  = z0; %inflow
Tube.qRemod= z0; %through flow for diameter adaptation
