function WorkBalance;
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl

global Par
Dt=Par.General.Dt;

FDot= @(a) conv2([a(end);a;a(1)],[+0.5;0;-0.5]/Dt,'valid');
PHem  = @(a) a.p.*FDot(a.V);
PSheet= @(a) a.T.*FDot(a.Am);
PSarc = @(a) a.Sarc.Sf.*FDot(a.Sarc.Ef)*a.VWall;

PHemL= PHem(Par.Lv);
PHemR= PHem(Par.Rv);
PHemLV= sum(PHemL)
PHemRV= sum(PHemR)
PHemTot= PHemL+PHemR;
PHemLa = PHem(Par.La);
PHemRa = PHem(Par.Ra);

PSheetL=PSheet(Par.Lv);
PSheetS=PSheet(Par.Sv);
PSheetR=PSheet(Par.Rv);
PSheetTot= PSheetL+PSheetS+PSheetR;
PSheetLa=PSheet(Par.La);
PSheetRa=PSheet(Par.Ra);

PSarcL=PSarc(Par.Lv);
PSarcS=PSarc(Par.Sv);
PSarcR=PSarc(Par.Rv);
PdSarcL=sum(PSarcL)/Par.Lv.VWall
PdSarcS=sum(PSarcS)/Par.Sv.VWall
PdSarcR=sum(PSarcR)/Par.Rv.VWall

PSarcTot= PSarcL+PSarcS+PSarcR;
PSarcLa=PSarc(Par.La);
PSarcRa=PSarc(Par.Ra);

figure(2); plot([PHemTot,PSheetTot,PSarcTot])
figure(3); plot([PSheetL,PSheetS,PSheetR,PSarcL,PSarcS,PSarcR])
figure(4); plot([PHemLa,PHemRa,PSarcLa,PSarcRa]);
disp(['Sum pDV,TdA,SfDEf,Diff: ',num2str(sum([PHemTot,...
    PSheetTot,PSarcTot,PSheetTot-PSarcTot]))]);
return