function [Par,StrDot]= WriteSVarFiles(Par);
% function [Par,StrDot]= WriteSVarFiles(Par);
% Should be executed with change of number or names of state variables
% Writes script files SVar2Par.m, Par2SVarDot.m and Par2SVar.m
% Adds Par.Scale to Par-structure for scaling of state variables in ODE
% Clears Par.SVar
% StrDot is a cell-list of strings, showing the state variables-Dot
% String part '~Dot' has been used as identification label for SVar's
% Theo Arts, Maastricht University
% Email: t.arts@bf.unimaas.nl
% Joost Lumens, Maastricht University
% November, 2008. Email: j.lumens@fys.unimaas.nl

%==============================================================
% Write and save program scripts for reading/writing State Variables
%==============================================================

G= Par.General;

% Find field strings in structure Par containing 'Dot'
StrDot= FindDot(Par); n= length(StrDot); % find SVarDot-variables

%==== Make String arrays of SVar and SVarDot
StrSVar= {}; StrSVarDot= {}; StrScale= {};
for i= 1:n
    SDot= StrDot{i}; % string containing xxxDot
    SvDot= strrep(SDot,'Dot(','Dot(:,'); % String XXXDot, represents SVarDot
    Sv= strrep(SvDot,'Dot',''); % String with Dot removed: State Variable
    SScale= Sv(end-2); % Letter used for scaling in ODE
    nr=str2num(Sv(end-1:end)); % number of SVar's in array, may be >1
    StrSVar   = [StrSVar   ;{Sv   }]; % state variables SVar
    StrSVarDot= [StrSVarDot;{SvDot}]; % SVarDot's
    StrScale  = [StrScale  ;{repmat([SScale,','],[1,nr])}]; % letter
    % last letter -> type of SVar
end

%=== Scaling of state variables to facilitate numerical solution
% characteristic letters become scaling factor
V= 10^round(log10(0.1*G.tCycle*G.qRest)); % scaling factors of volume,
i= 1;                                     % scaling of sarcomere length
q= 10^round(log10(G.qRest));              % scaling of flow
C= 1;                                     % scaling of contractility factor
t= 1;                                     % scaling of time
Y= 10^round(log10(G.tCycle*G.qRest)/3);   % scaling of length

eval(['Par.Scale= [', [StrScale{:}],']'';']);
%column vector for scaling of State Variables SVar stored in Par.Scale

% Writing of script files for extracting state variables
% Creating script SVar2Par.m
% ... Par.ValveLVen(1).q= Par.Scale(2)*Par.SVar(:,2); ...
fid = fopen('SVar2Par.m','w');
j=1; % counter for state variables
for i= 1:length(StrSVar);
    StrV= StrSVar{i}(1:end-2);
    nr= str2num(StrSVar{i}(end-1:end));
    if nr==1
        strnr1=[ '(:,' , num2str(j) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    else
        strnr1=[ '(:,' , num2str(j) , ':' , num2str(j+nr-1) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    end
    Str= ['Par.',StrV,'= Par.Scale' , strnr2, '*Par.SVar' ,strnr1,';'];
    fprintf(fid,[Str,'\n']);
    j=j+nr;
end
fclose(fid);

% Creating script Par2SVarDot.m
% ... Par.SVarDot(:,2)= Par.ValveLVen(1).qDot/Par.Scale(2); ...
fid = fopen('Par2SVarDot.m','w');
j=1; % counter for state variables
for i= 1:length(StrSVar);
    StrV= StrSVarDot{i}(1:end-2);
    nr= str2num(StrSVarDot{i}(end-1:end));
    if nr==1
        strnr1=[ '(:,' , num2str(j) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    else
        strnr1=[ '(:,' , num2str(j) , ':' , num2str(j+nr-1) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    end
    Str=['Par.SVarDot',strnr1,'= Par.',StrV,'/Par.Scale',strnr2,';'];
    fprintf(fid,[Str,'\n']);
    j=j+nr;
end
fclose(fid);

% Creating script Par2SVar.m
% ... Par.SVar(:,2)= Par.ValveLVen(1).q/Par.Scale(2); ...
fid = fopen('Par2SVar.m','w');
j=1;
for i= 1:length(StrSVar);
    StrV= StrSVar{i}(1:end-2);
    nr= str2num(StrSVar{i}(end-1:end));
    if nr==1
        strnr1=[ '(:,' , num2str(j) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    else
        strnr1=[ '(:,' , num2str(j) , ':' , num2str(j+nr-1) , ')' ];
        strnr2=[ '('   , num2str(j) , ')' ];
    end
    Str=['Par.SVar',strnr1,'= Par.',StrV,'/Par.Scale',strnr2,';'];
    fprintf(fid,[Str,'\n']);
    j=j+nr;
end
fclose(fid);

% Clear state variables
Par.SVar=[]; Par.SVarDot=[];
%----- end script for program file writing
return


% ============== Auxiliary functions ================

function Str= FindDot(Struct);
% Returns array of strings pointing to State VariablesDot in tree structure
global Str j;
Str= {}; j= 0;
FindStr(Struct);
disp(['Number of state variables: ',num2str(j)]);
% disp(Str'); % display state variables
return

%= used recursively inside FindDot
function StrTot= FindStr(Struct,varargin);
% function StrTot= FindStr(Struct,varargin);
% Finds Field names with 'Dot' in a tree structure
% Algorithm based on function MapStructure(Struct)
% Nested search in structure tree
% The varargin facility is needed for nesting in this procedure

%INPUT
% Struct= stucture to map
% varargin{1}= nr, current branch number
% varargin{2}= depth, depth in structure tree
% varargin{3}= string array of output
%OUTPUT
% cell array of strings, containing output to print
%Theo Arts, May 25, 2008
%==== initialization of Root of structure

global Str j;

if nargin<4; % initialization of Root of structure
    nr= 1; depth= 0; StrTot= {};
else
    nr= varargin{1}; depth= varargin{2}; StrTot= varargin{3};
end

if ~isstruct(Struct); return; end; % Escape if not a structure
Fn1= fieldnames(Struct);
n1 = length(Fn1);

for i1= 1:n1, %search fields
    Twig= getfield(Struct,{1},Fn1{i1}); % Twig structure, suited as root
    % Equivalent with Twig= Struct(1)."Fn1{i1}"
    if isstruct(Twig);
        Len= length(Twig); % Array length of Twig
    else
        Len= min(1,length(Twig));
    end
    %   if (~ischar(Twig));
    StrTot{depth+1}= Fn1{i1};
    for i2= 1:Len; % for all array elements of Twig
        StrTot{depth+1}= [Fn1{i1},'(',num2str(i2),').'];
        if strfind(Fn1{i1},'Dot') & length(strfind(Fn1{i1},'SVarDot'))== 0;
            % exclude Par.SVarDot from search
            nDot=size(Struct.(Fn1{i1}),2); %number of SVar in array
            S1= [StrTot{1:depth+1}];
            S= [S1(1:end-4),num2str(nDot,'%02d')]; % storing nDot in string
            Str= [Str;{S}]; j= j+nDot; % cumulation of state variables
%              disp(S);
        end
        if isstruct(Twig(i2))
            StrTot= FindStr(Twig(i2),i2,depth+1,StrTot);
        end
    end
end
return

