// *****************************************************************************
//                              O N E   E N Z Y M E
// *****************************************************************************

//  This model represents the single enzyme reversible reaction shown below:

//                        k1 -->            k2 -->
//             S + E  <----------->  ES  ----------->  P + E
//                       <-- k_1           
 

	import nsrunit;
	unit conversion on;

	math One_Enzyme{


// *****************************************************************************
//                       M O D E L   P A R A M E T E R S
// *****************************************************************************


	real 				// INPUT AND CALCULATED PARAMETERS				



// *****************************************************************************
//                        M O D E L   V A R I A B L E S
// *****************************************************************************

	realDomain 			// DOMAIN VARIABLE



	real 				// STATE VARIABLES


// *****************************************************************************
//                      I N I T I A L   C O N D I T I O N S
// *****************************************************************************




// *****************************************************************************
//                   S E T   O F   M O D E L   E Q U A T I O N S
// *****************************************************************************



// *****************************************************************************
//                           R E F E R E N C E S
// *****************************************************************************

//  1. Bassingthwaighte JB. 
//     Enzymes and Metabolic Reactions.  
//     Chapter 10 in "Transport and Reactions in Biological Systems", 
//     Pages 7-8

	}

//  End of PROGRAM   O N E   E N Z Y M E
